/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void copyBean(Object source, Object target, String ... ignores) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignores);
    }

    public static <T> List<T> copyBeanList(Iterable iterable, Class<T> targetClazz) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Object o : iterable) {
            try {
                T t = targetClazz.newInstance();
                BeanUtils.copyProperties(o, t);
                newList.add(t);
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        return newList;
    }

    public static <T> Page<T> copyBeanPage(Page page, Pageable pageable, Class<T> targetClazz) {
        List<T> newList = BeanUtil.copyBeanList((Iterable)page, targetClazz);
        return new PageImpl(newList, pageable, page.getTotalElements());
    }

    public static <T> List<String> getIds(List<T> list, Class clazz, String methodName) {
        ArrayList<String> ids = new ArrayList<String>(list.size());
        try {
            Method m = clazz.getMethod(methodName, new Class[0]);
            for (T t : list) {
                String id = (String)m.invoke(t, new Object[0]);
                ids.add(id);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        return ids;
    }

    private static List<Method> getAllMethod(Object obj) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<Object> clazz = obj.getClass();
        while (!clazz.isAssignableFrom(Object.class)) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static Map<String, Object> convertMap(Object obj) {
        List<Method> methods = BeanUtil.getAllMethod(obj);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (Method m : methods) {
            String methodName = m.getName();
            if (!methodName.startsWith("get")) continue;
            String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            try {
                map.put(propertyName, m.invoke(obj, new Object[0]));
            }
            catch (IllegalAccessException e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public void transMapToBean(Map<String, Object> map, Object obj) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            logger.info("transMap2Bean Error " + e);
        }
    }
}

