package cn.gtmap.gtc.workflow.enums.manage;

/**
 * @Author xieziwei
 * @Date 2023/4/21 11:00
 * @PackageName:cn.gtmap.gtc.workflow.enums.manage
 * @ClassName: AlarmLevel
 * @Description: 预警级别返回值
 */
public enum AlarmLevel {

    /**
     * 预警级别 - 高
     * 1 任务办理时长超过 80%
     */
    HighPriority("预警级别 - 高",3),

    /**
     * 预警级别 - 中
     * 任务办理时长超过 50% 还没到 80%
     */
    MediumPriority("预警级别 - 中",2),

    /**
     * 预警级别 - 低
     * 1 任务办理时长低于 50%
     */
    LowPriority("预警级别 - 低",1);

    private String description;


    private int level;

    AlarmLevel(String description, int level) {
        this.description = description;
        this.level = level;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String toString() {
        return "AlarmLevel{" +
                "description='" + description + '\'' +
                ", level=" + level +
                '}';
    }
}
