package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.entity.StrategyInfo;
import cn.gtmap.gtc.workflow.entity.UserWeightInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface AutoDispatchConfigClient {

    @GetMapping(value = "/auto-dispatch-config/saveUserWeightInfo")
    public void saveUserWeightInfo(@RequestParam("processDefId") String processDefId, @RequestParam("activityId") String activityId,
                                   @RequestParam("userId") String userId, @RequestParam("userName")String userName, @RequestParam("alias")String alias,
                                   @RequestParam("enable") String enable, @RequestParam(name = "sort",required = false)String sort,
                                   @RequestParam(name = "weight",required = false)String weight);


    @GetMapping(value = "/auto-dispatch-config/saveStrategyInfo")
    public void saveStrategyInfo(@RequestParam(name = "processDefId",required = false) String processDefId, @RequestParam(name = "activityId",required = false) String activityId,
                                 @RequestParam("strategyType") String strategyType,@RequestParam("url")String url,@RequestParam("appName")String appName
            ,@RequestParam("nodeType")String nodeType,@RequestParam(name = "enabled",required = false) String enabled,@RequestParam(name = "openUrlAddress",required = false) String openUrlAddress
            ,@RequestParam(name = "openAppName",required = false) String openAppName,@RequestParam(name = "procDayLimit",required = false) Integer procDayLimit) ;


    @GetMapping(value = "/auto-dispatch-config/getAllUserWeightInfo")
    public List<UserWeightInfo> getAllUserInfos();

    @GetMapping(value = "/auto-dispatch-config/findStragetyByKey")
    public StrategyInfo findStragetyByKey(@RequestParam(name = "nodeType",required = false) String nodeType,
                                          @RequestParam(name = "processDefId",required = false) String processDefId,
                                          @RequestParam(name = "activityId",required = false) String activityId);

    @GetMapping(value = "/auto-dispatch-config/isDepartmentFilterNode")
    public boolean isDepartmentFilterNode(@RequestParam("processDefKey") String processDefKey,@RequestParam("activityId") String activityId);

    @GetMapping(value = "/auto-dispatch-config/isDispatchEnable")
    public boolean isDispatchEnable();


    @GetMapping(value = "/auto-dispatch-config/getUserInfosByProcDefKeyAndActId")
    public List<UserWeightInfo>  getUserInfosByProcDefKeyAndActId(@RequestParam("processDefKey") String processDefKey,
                                                                  @RequestParam("activityId") String activityId);


    @GetMapping(value = "/auto-dispatch-config/delUserWeightInfo")
    public void delUserWeightInfo(@RequestParam("processDefKey") String processDefKey, @RequestParam("activityId") String activityId,@RequestParam("userName")String userName);


}
