/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import cn.gtmap.gtc.workflow.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDayUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkDayUtil.class);
    private static final String ERROR_DATE_FORMAT = "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e";
    private static final long DAY_TO_MILLISECOND = 86400000L;

    public static String getDateByAddDays(String day, int num) {
        Date nowDate;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            nowDate = df.parse(day);
        }
        catch (ParseException e) {
            LOGGER.error(ERROR_DATE_FORMAT, (Throwable)e);
            return null;
        }
        Date newDate2 = new Date(nowDate.getTime() + (long)num * 86400000L);
        return df.format(newDate2);
    }

    public static String getDateByDelDays(String day, int num) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = null;
        try {
            nowDate = df.parse(day);
        }
        catch (ParseException e) {
            LOGGER.error(ERROR_DATE_FORMAT, (Throwable)e);
            return null;
        }
        Date newDate2 = new Date(nowDate.getTime() - (long)num * 86400000L);
        return df.format(newDate2);
    }

    public static Map<String, Object> getDueDateNum(Date dueDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Date dayDate = null;
        Date hourDate = null;
        try {
            dayDate = df.parse("2000-01-01");
            hourDate = df.parse("2100-01-01");
        }
        catch (ParseException e) {
            LOGGER.error(ERROR_DATE_FORMAT, (Throwable)e);
            return null;
        }
        if (dueDate.getTime() > hourDate.getTime()) {
            result.put("type", (Object)ComputeMode.HOUR);
            int num = (int)((dueDate.getTime() - hourDate.getTime()) / 86400000L);
            result.put("num", num);
        } else {
            result.put("type", (Object)ComputeMode.DAY);
            int num = (int)((dueDate.getTime() - dayDate.getTime()) / 86400000L);
            result.put("num", num);
        }
        return result;
    }

    public static Map<String, Object> getDueDateNum(String dueDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return WorkDayUtil.getDueDateNum(df.parse(dueDate));
        }
        catch (ParseException e) {
            LOGGER.error(ERROR_DATE_FORMAT, (Throwable)e);
            return null;
        }
    }

    public static Date getNextReckonTime(Date date) {
        if (null == date) {
            date = new Date();
        }
        Calendar reckonTime = DateUtils.toCalendar(date);
        reckonTime.set(12, 0);
        reckonTime.set(13, 0);
        reckonTime.set(14, 0);
        return reckonTime.getTime();
    }

    public static enum ComputeMode {
        MIN(3, "\u6309\u5206\u949f\u8ba1\u7b97", "M"),
        DAY(2, "\u6309\u5929\u8ba1\u7b97", "D"),
        HOUR(1, "\u6309\u5c0f\u65f6\u8ba1\u7b97", "H"),
        NONE(0, "\u4e0d\u8ba1\u7b97", "N");

        private int value;
        private String remark;
        private String name;

        private ComputeMode(int value, String remark, String name) {
            this.value = value;
            this.remark = remark;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getRemark() {
            return this.remark;
        }

        public String getName() {
            return this.name;
        }

        public static ComputeMode getByValue(int value) {
            for (ComputeMode computeMode : ComputeMode.values()) {
                if (computeMode.value != value) continue;
                return computeMode;
            }
            return NONE;
        }

        public static ComputeMode getByName(String name) {
            for (ComputeMode computeMode : ComputeMode.values()) {
                if (!computeMode.name.equals(name)) continue;
                return computeMode;
            }
            return NONE;
        }
    }
}

