/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.helper;

import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.helper.AbstractWorkdayHelper;
import cn.gtmap.gtc.workflow.utils.DateUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

public class StrictWorkdayHelper
extends AbstractWorkdayHelper {
    public StrictWorkdayHelper(List<WorkDay> list) {
        this.init(list);
    }

    @Override
    public Calendar addDateByWorkDay(Calendar calendar, int day) throws ParseException {
        AbstractWorkdayHelper.WorkDayTimeType workDayTimeType = this.checkWorkTimeType(calendar);
        Calendar dueCalendar = null;
        if (workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.NOT_WORKDAY || workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.BEFORE_MORNING_STRAT || workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.AFTER_AFTERNOON_END) {
            Calendar realStartTime = this.getNearWorkTime(calendar, workDayTimeType);
            String realStartDateStr = this.dateFormat.format(realStartTime.getTime());
            int indexInWorkDay = (Integer)this.indexMap.get(realStartDateStr) + (day - 1);
            WorkDay workDay = (WorkDay)this.workDayList.get(indexInWorkDay);
            dueCalendar = DateUtils.toCalendar(workDay.getWorkDay() + " " + workDay.getAfternoonTimeEnd(), DateUtils.DateFormatType.DATETIME);
        } else {
            String dateStr = this.dateFormat.format(calendar.getTime());
            int indexInWorkDay = (Integer)this.indexMap.get(dateStr);
            int dueIndexInWorkDay = indexInWorkDay + day;
            WorkDay startWorkDay = (WorkDay)this.workDayList.get(indexInWorkDay);
            WorkDay dueWorkDay = (WorkDay)this.workDayList.get(dueIndexInWorkDay);
            if (workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.LUNCH_BREAK) {
                dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + dueWorkDay.getMorningTimeEnd(), DateUtils.DateFormatType.DATETIME);
            } else if (workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.MORNING_WORKTIME) {
                int temp = DateUtils.getTimeDifferenceInMinutesByTime(startWorkDay.getMorningTimeStart(), this.timeFormat.format(calendar.getTime()));
                dueCalendar = temp >= ((AbstractWorkdayHelper.WorkMinutes)this.workMinutesList.get(dueIndexInWorkDay)).getMorningMinutes() ? DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + dueWorkDay.getMorningTimeEnd(), DateUtils.DateFormatType.DATETIME) : DateUtils.addMinutes(DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + dueWorkDay.getMorningTimeStart(), DateUtils.DateFormatType.DATETIME), temp);
            } else if (workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.AFTERNOON_WORKTIME) {
                int temp = DateUtils.getTimeDifferenceInMinutesByTime(startWorkDay.getAfternoonTimeStart(), this.timeFormat.format(calendar.getTime()));
                dueCalendar = temp >= ((AbstractWorkdayHelper.WorkMinutes)this.workMinutesList.get(dueIndexInWorkDay)).getAfternoonMinutes() ? DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + dueWorkDay.getAfternoonTimeEnd(), DateUtils.DateFormatType.DATETIME) : DateUtils.addMinutes(DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + dueWorkDay.getAfternoonTimeStart(), DateUtils.DateFormatType.DATETIME), temp);
            }
        }
        return dueCalendar;
    }
}

