package cn.gtmap.gtc.workflow.utils.manager;

import java.util.HashMap;
import java.util.Map;

/**
 * @Classname cn.gtmap.gtc.workflow.manage.utils.project
 * @Description TODO
 * @Date 2020/4/26 10:54
 * @Created by zhouk
 */
public class RequestKeyUtils {

    public static final String TASK_TABLE_NAME = "taskWhereSql";                                             //历史任务表
    public static final String ACT_ST_TASK_TABLE_NAME = "actStTaskWhereSql";                                //统计任务
    public static final String ACT_ST_PRO_REL_TABLE_NAME = "dynamicCloumnWhereSql";                          //流程扩展
    public static final String ACT_RE_PROCDEF_TABLE_NAME = "actReProcdefWhereSql";                          //流程定义
    public static final String ACT_HI_PROCINST_TABLE_NAME = "actHiProcinstWhereSql";                        //历史流程
    public static final String ACT_ST_PROC_TABLE_NAME = "actStProcWhereSql";                                //统计流程
    public static final String ACT_CF_DEFINE_ROLE_REL_TABLE_NAME = "actCfDefineRoleRelWhereSql";          //角色关联
    public static final String DYNAMIC_CLOUMN_TABLE_NAME = "dynamicCloumn";                               //sql 的动态列

    public static final String COMPLETE_TASK_ORDER_SQL = "actHiTaskinstOrderSql";                         //完成任务的排序
    public static final String PROCESS_ORDER_SQL = "actHiProcinstOrderSql";

    public static final String QUERY_VALUE_TYPR_STRING = "string";                     //通用key查询的value类型为String
    public static final String QUERY_VALUE_TYPR_INT = "number";                        //通用key查询的value类型为number
    public static final String QUERY_VALUE_TYPR_DATE = "date";                        //通用key查询的value类型为date

    private static Map<String, String> getAllTaskMap() {
        HashMap<String, String> maps = new HashMap<>();
        maps.put("taskId", "task.ID");
        maps.put("taskClaimTime", "task.CLAIM_TIME_");
        maps.put("taskAssigin", "task.ASSIGNEE_");
        maps.put("taskAssiginName", "ACT_ST_TASK.TASK_ASS_NAME");
        maps.put("taskKey", "task.TASK_DEF_KEY_");
        maps.put("taskStatus", "ACT_ST_TASK.TASK_STATUS");
        maps.put("taskType", "ACT_ST_TASK.TASK_TYPE");
        maps.put("taskName", "task.NAME_");
        maps.put("processInstanceId", "task.PROC_INST_ID_");
        maps.put("processInstanceName", "ACT_HI_PROCINST.NAME");
        maps.put("procStatus", "ACT_ST_PROC.PROC_STATUS");
        maps.put("procTimeOutStatus", "ACT_ST_PROC.PROC_TIMEOUT_STATUS");
        maps.put("startTime_todo", "task.CREATE_TIME_");
        maps.put("startTime_complete", "task.START_TIME_");
        maps.put("endTime", "ACT_ST_TASK.TASK_END_DATE");
        maps.put("priority", "task.PRIORITY_");
        maps.put("startUserId", "ACT_ST_PROC.START_USER_ID");
        maps.put("startUserName", "ACT_ST_TASK.PROC_START_USER_NAME");
        maps.put("processDefId", "task.PROC_DEF_ID_");
        maps.put("processKey", "ACT_ST_PROC.PROC_DEF_KEY");
        maps.put("processDefName", "ACT_ST_PROC.PROC_DEF_NAME");
        maps.put("delegation", "task.DELEGATION_");
        maps.put("category", "task.CATEGORY_");
        maps.put("taskDueDays", "ACT_ST_TASK.TASK_DUE_DAYS");
        maps.put("taskDueHours", "ACT_ST_TASK.TASK_DUE_HOURS");
        maps.put("taskTimeoutDays", "ACT_ST_TASK.TASK_TIMEOUT_DAYS");
        maps.put("taskTimeoutHours", "ACT_ST_TASK.TASK_TIMEOUT_HOURS");
        maps.put("projectId", "ACT_ST_PRO_REL.PROJECT_ID");
        maps.put("projectName", "ACT_ST_PRO_REL.PROJECT_NAME");
        maps.put("taskOrg", "ACT_ST_TASK.TASK_ASS_DEP_ID");
        maps.put("procTimeout", "ACT_ST_PROC.PROC_TIMEOUT_COUNT");
        maps.put("taskAssRoleId", "ACT_ST_TASK.TASK_ASS_ROLE_ID");
        // 启动人员部门
        maps.put("startUserDepId", "ACT_ST_PROC.START_USER_DEP");
        maps.put("taskUrgentReason", "ACT_ST_TASK.TASK_URGENT_REASON");
        maps.put("dispatchStatus", "ACT_ST_TASK.DISPATCH_STATUS");
        return maps;
    }

    public static Map<String, String> getAllTableName() {
        HashMap<String, String> maps = new HashMap<>();
        maps.put("taskId", TASK_TABLE_NAME);
        maps.put("taskAssigin", TASK_TABLE_NAME);
        maps.put("taskAssiginName", ACT_ST_TASK_TABLE_NAME);
        maps.put("taskKey", TASK_TABLE_NAME);
        maps.put("taskName", TASK_TABLE_NAME);
        maps.put("startTime_todo", TASK_TABLE_NAME);
        maps.put("startTime_complete", TASK_TABLE_NAME);
        maps.put("processDefId", TASK_TABLE_NAME);
        maps.put("priority", TASK_TABLE_NAME);
        maps.put("delegation", TASK_TABLE_NAME);
        maps.put("category", TASK_TABLE_NAME);
        maps.put("processInstanceId", TASK_TABLE_NAME);

        maps.put("taskStatus", ACT_ST_TASK_TABLE_NAME);
        maps.put("taskType", ACT_ST_TASK_TABLE_NAME);
        maps.put("processInstanceName", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("procStatus", ACT_ST_PROC_TABLE_NAME);
        maps.put("procTimeOutStatus", ACT_ST_PROC_TABLE_NAME);
        maps.put("endTime", ACT_ST_TASK_TABLE_NAME);
        maps.put("startUserId", ACT_ST_PROC_TABLE_NAME);
        maps.put("startUserName", ACT_ST_TASK_TABLE_NAME);
        maps.put("processKey", ACT_ST_PROC_TABLE_NAME);
        maps.put("procSameRegionComplete", ACT_ST_PROC_TABLE_NAME);
        maps.put("processDefName", ACT_ST_PROC_TABLE_NAME);
        maps.put("taskDueDays", ACT_ST_TASK_TABLE_NAME);
        maps.put("taskDueHours", ACT_ST_TASK_TABLE_NAME);
        maps.put("taskTimeoutDays", ACT_ST_TASK_TABLE_NAME);
        maps.put("taskTimeoutHours", ACT_ST_TASK_TABLE_NAME);
        maps.put("projectId", ACT_ST_PRO_REL_TABLE_NAME);
        maps.put("projectName", ACT_ST_PRO_REL_TABLE_NAME);
        maps.put("taskOrg", ACT_ST_TASK_TABLE_NAME);
        maps.put("procTimeout", ACT_ST_PROC_TABLE_NAME);
        maps.put("taskAssRoleId", ACT_ST_TASK_TABLE_NAME);
        maps.put("startUserDepId", ACT_ST_PROC_TABLE_NAME);
        maps.put("taskUrgentReason", ACT_ST_TASK_TABLE_NAME);
        maps.put("dispatchStatus", ACT_ST_TASK_TABLE_NAME);

        return maps;
    }

    private static Map<String, String> getProcAllMap() {
        HashMap<String, String> maps = new HashMap<>();
        maps.put("proc_all_status", "");
        maps.put("taskAssigin", ""); //特殊查询，流程查任务受理人
        maps.put("taskAssRoleId", "ACT_CF_DEFINE_ROLE_REL.USER_ROLE");
        maps.put("startUserDepId", "ACT_ST_PROC.START_USER_DEP");
        maps.put("procInsId", "ahpi.PROC_INST_ID_");
        maps.put("processInstanceName", "ahpi.NAME_");
        maps.put("startActivityId", "ahpi.START_ACT_ID_");
        maps.put("startUserId", "ACT_ST_PROC.START_USER_ID");
        maps.put("startTime", "ahpi.START_TIME_");
        maps.put("endTime", "ahpi.END_TIME_");
        maps.put("priority", "ACT_ST_PROC.PRIORITY");
        maps.put("deleteReason", "ahpi.DELETE_REASON_");
        maps.put("procSameRegionComplete","ACT_ST_PROC.SAME_REGION");
        maps.put("procDefId", "ahpi.PROC_DEF_ID_");
        maps.put("processKey", "ACT_ST_PROC.PROC_DEF_KEY");
        maps.put("procDueType", "ACT_ST_PROC.PROC_DUE_TYPE");
        maps.put("procDueLimit", "ACT_ST_PROC.PROC_DUE_LIMIT");
        maps.put("procDueTime", "ACT_ST_PROC.PROC_DUE_TIME");
        maps.put("startUserName", "ACT_ST_PROC.START_USER_NAME");
        maps.put("procTimeoutCount", "ACT_ST_PROC.PROC_TIMEOUT_COUNT");
        maps.put("procTimeoutStatus", "ACT_ST_PROC.PROC_TIMEOUT_STATUS");
        maps.put("procStatus", "ACT_ST_PROC.PROC_STATUS");
        maps.put("category", "ACT_ST_PROC.CATEGORY");
        maps.put("projectId", "ACT_ST_PRO_REL.PROJECT_ID");
        maps.put("projectName", "ACT_ST_PRO_REL.PROJECT_NAME");
        maps.put("procUrgentReason", "ACT_ST_PROC.PROC_URGENT_REASON");
        return maps;
    }

    private static Map<String, String> getProcNameMap() {
        HashMap<String, String> maps = new HashMap<>();
        maps.put("taskAssigin", ACT_HI_PROCINST_TABLE_NAME); //特殊查询，流程查任务受理人
        maps.put("taskAssRoleId", ACT_CF_DEFINE_ROLE_REL_TABLE_NAME);
        maps.put("startUserDepId", ACT_ST_PROC_TABLE_NAME);
        maps.put("procInsId", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("priority", ACT_ST_PROC_TABLE_NAME);
        maps.put("processInstanceName", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("startActivityId", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("startUserId", ACT_ST_PROC_TABLE_NAME);
        maps.put("startTime", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("endTime", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("deleteReason", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("procDefId", ACT_HI_PROCINST_TABLE_NAME);
        maps.put("processKey", ACT_ST_PROC_TABLE_NAME);
        maps.put("procSameRegionComplete", ACT_ST_PROC_TABLE_NAME);
        maps.put("procDueType", ACT_ST_PROC_TABLE_NAME);
        maps.put("procDueLimit", ACT_ST_PROC_TABLE_NAME);
        maps.put("procDueTime", ACT_ST_PROC_TABLE_NAME);
        maps.put("startUserName", ACT_ST_PROC_TABLE_NAME);
        maps.put("procTimeoutCount", ACT_ST_PROC_TABLE_NAME);
        maps.put("procTimeoutStatus", ACT_ST_PROC_TABLE_NAME);
        maps.put("procStatus", ACT_ST_PROC_TABLE_NAME);
        maps.put("category", ACT_ST_PROC_TABLE_NAME);
        maps.put("projectId", ACT_ST_PRO_REL_TABLE_NAME);
        maps.put("projectName", ACT_ST_PRO_REL_TABLE_NAME);
        maps.put("procUrgentReason", ACT_ST_PROC_TABLE_NAME);
        return maps;
    }

    public static boolean isTaskContains(String value) {
        Map<String, String> maps = getAllTaskMap();
        return maps.containsKey(value);
    }

    public static String getTaskcolumn(String value) {
        Map<String, String> maps = getAllTaskMap();
        return maps.get(value);
    }

    public static String getTaskName(String key) {
        Map<String, String> maps = getAllTableName();
        if (isTaskContains(key)) {
            return maps.get(key);
        } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(key)) {
            return ACT_ST_PRO_REL_TABLE_NAME;
        }
        return null;
    }

    public static boolean isProcContains(String value) {
        Map<String, String> maps = getProcAllMap();
        return maps.containsKey(value);
    }

    public static String getProccolumn(String value) {
        Map<String, String> maps = getProcAllMap();
        return maps.get(value);
    }

    public static String getProcName(String key) {
        Map<String, String> maps = getProcNameMap();
        if (isProcContains(key)) {
            return maps.get(key);
        } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(key)) {
            return ACT_ST_PRO_REL_TABLE_NAME;
        }
        return null;
    }


    public static Map<String, String> getTaskKeyType = new HashMap<String, String>() {{
        put("taskId", QUERY_VALUE_TYPR_STRING);
        put("taskAssigin", QUERY_VALUE_TYPR_STRING);
        put("taskKey", QUERY_VALUE_TYPR_STRING);
        put("taskStatus", QUERY_VALUE_TYPR_STRING);  //特色处理
        put("taskType", QUERY_VALUE_TYPR_INT);
        put("taskName", QUERY_VALUE_TYPR_STRING);
        put("processInstanceId", QUERY_VALUE_TYPR_STRING);
        put("processInstanceName", QUERY_VALUE_TYPR_STRING);
        put("procStatus", QUERY_VALUE_TYPR_INT);
        put("procTimeOutStatus", QUERY_VALUE_TYPR_INT);
        put("startTime_todo", QUERY_VALUE_TYPR_DATE);
        put("startTime_complete", QUERY_VALUE_TYPR_DATE);
        put("endTime", QUERY_VALUE_TYPR_DATE);
        put("priority", QUERY_VALUE_TYPR_INT);
        put("startUserId", QUERY_VALUE_TYPR_STRING);
        put("startUserName", QUERY_VALUE_TYPR_STRING);
        put("processDefId", QUERY_VALUE_TYPR_STRING);
        put("processKey", QUERY_VALUE_TYPR_STRING);
        put("processDefName", QUERY_VALUE_TYPR_STRING);
        put("delegation", QUERY_VALUE_TYPR_INT);
        put("category", QUERY_VALUE_TYPR_STRING);
        put("taskDueDays", QUERY_VALUE_TYPR_INT);
        put("taskDueHours", QUERY_VALUE_TYPR_INT);
        put("taskTimeoutDays", QUERY_VALUE_TYPR_INT);
        put("taskTimeoutHours", QUERY_VALUE_TYPR_INT);
        put("projectId", QUERY_VALUE_TYPR_STRING);
        put("projectName", QUERY_VALUE_TYPR_STRING);
        put("taskOrg", QUERY_VALUE_TYPR_STRING);
        put("procTimeout", QUERY_VALUE_TYPR_INT);
        put("taskAssRoleId", QUERY_VALUE_TYPR_STRING);
        put("startUserDepId", QUERY_VALUE_TYPR_STRING);
        put("taskUrgentReason", QUERY_VALUE_TYPR_STRING);

    }};

    public static Map<String, String> getProcKeyType = new HashMap<String, String>() {{
        put("taskAssigin", QUERY_VALUE_TYPR_STRING); //特殊查询，流程查任务受理人
        put("taskAssRoleId", QUERY_VALUE_TYPR_STRING);
        put("startUserDepId", QUERY_VALUE_TYPR_STRING);
        put("procInsId", QUERY_VALUE_TYPR_STRING);
        put("processInstanceName", QUERY_VALUE_TYPR_STRING);
        put("startActivityId", QUERY_VALUE_TYPR_STRING);
        put("startUserId", QUERY_VALUE_TYPR_STRING);
        put("startTime", QUERY_VALUE_TYPR_DATE);
        put("endTime", QUERY_VALUE_TYPR_DATE);
        put("priority", QUERY_VALUE_TYPR_INT);
        put("deleteReason", QUERY_VALUE_TYPR_STRING);
        put("procDefId", QUERY_VALUE_TYPR_STRING);
        put("processKey", QUERY_VALUE_TYPR_STRING);
        put("procDueType", QUERY_VALUE_TYPR_STRING);
        put("procDueLimit", QUERY_VALUE_TYPR_INT);
        put("procDueTime", QUERY_VALUE_TYPR_DATE);
        put("startUserName", QUERY_VALUE_TYPR_STRING);
        put("procTimeoutCount", QUERY_VALUE_TYPR_INT);
        put("procTimeoutStatus", QUERY_VALUE_TYPR_INT);
        put("procStatus", QUERY_VALUE_TYPR_INT);
        put("category", QUERY_VALUE_TYPR_STRING);
        put("projectId", QUERY_VALUE_TYPR_STRING);
        put("projectName", QUERY_VALUE_TYPR_STRING);
        put("procUrgentReason", QUERY_VALUE_TYPR_STRING);
    }};
}
