package cn.gtmap.gtc.workflow.utils.manager;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @Classname cn.gtmap.gtc.workflow.manage.utils.project
 * @Description 数据库工具类
 * @Date 2020/3/31 17:04
 * @Created by zhouk
 */
public class DatabaseTypeUtils {

    public static final String DATABASE_TYPE_MYSQL = "mysql";
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_PGSQL = "postgresql";
    //mysql所有字段类型
    public static final Set<String> MYSQL_SET = new HashSet<String>() {{
        add("bigint");
        add("binary");
        add("bit");
        add("blob");
        add("char");
        add("date");
        add("datetime");
        add("decimal");
        add("double");
        add("enum");
        add("float");
        add("geometry");
        add("geometrycollection");
        add("int");
        add("integer");
        add("longtext");
        add("linestring");
        add("longblob");
        add("json");
        add("mediumblob");
        add("mediumblob");
        add("mediumint");
        add("mediumtext");
        add("multilinestring");
        add("multipoint");
        add("multipolygon");
        add("numeric");
        add("point");
        add("polygon");
        add("real");
        add("set");
        add("smallint");
        add("text");
        add("time");
        add("timestamp");
        add("tinyblob");
        add("tinyint");
        add("tinytext");
        add("varbinary");
        add("varchar");
        add("year");
    }};
    //mysql的日期字段类型
    public static final Set<String> MYSQL_DATE_SET = new HashSet<String>() {{
        add("date");
        add("datetime");
        add("time");
        add("timestamp");
        add("year");
    }};
    //mysql的字段类型
    public static final Map<String, String> MYSQL_DATA_TYPE_MAP = new HashMap<String, String>() {{
        put("bigint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("binary", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("bit", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("blob", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("char", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("date", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("datetime", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("decimal", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("double", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("enum", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("float", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("geometry", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("geometrycollection", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("int", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("integer", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("longtext", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("linestring", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("longblob", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("json", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("mediumblob", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("mediumblob", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("mediumint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("mediumtext", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("multilinestring", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("multipoint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("multipolygon", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("numeric", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("point", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("polygon", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("real", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("set", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("smallint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("text", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("time", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("timestamp", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("tinyblob", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("tinyint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("tinytext", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("varbinary", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("varchar", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("year", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
    }};

    //oracle所有字段类型
    public static final Set<String> ORACLE_SET = new HashSet<String>() {{
        add("BFILE");
        add("BINARY_DOUBLE");
        add("BINARY_FLOAT");
        add("BLOB");
        add("CHAR");
        add("CHAR VARYING");
        add("CHARACTER");
        add("CHARACTER VARYING");
        add("CLOB");
        add("DATE");
        add("DECIMAL");
        add("DOUBLE PRECISION");
        add("FLOAT");
        add("INT");
        add("INTEGER");
        add("INTERVAL DAY TO SECOND");
        add("INTERVAL YEAR TO MONTH");
        add("LONG");
        add("LONG RAW");
        add("LONG VARCHAR");
        add("NATIONAL CHAR");
        add("NATIONAL CHAR VARYING");
        add("NATIONAL CHARACTER");
        add("NATIONAL CHARACTER VARYING");
        add("NCHAR");
        add("NCHAR VARYING");
        add("NCLOB");
        add("NUMBER");
        add("NUMERIC");
        add("NVARCHAR2");
        add("RAW");
        add("REAL");
        add("ROWID");
        add("SMALLINT");
        add("TIMESTAMP");
        add("TIMESTAMP WITH LOCAL TIME ZONE");
        add("TIMESTAMP WITH TIME ZONE");
        add("UROWID");
        add("VARCHAR");
        add("VARCHAR2");
    }};
    //oracle的日期字段类型
    public static final Set<String> ORACLE_DATE_SET = new HashSet<String>() {{
        add("DATE");
        add("TIMESTAMP");
        add("TIMESTAMP WITH LOCAL TIME ZONE");
        add("TIMESTAMP WITH TIME ZONE");
    }};
    //oracle的字段类型
    public static final Map<String, String> ORACLE_DATA_TYPE_MAP = new HashMap<String, String>() {{
        put("BFILE", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("BINARY_DOUBLE", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("BINARY_FLOAT", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("BLOB", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("CHAR", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("CHAR VARYING", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("CHARACTER", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("CHARACTER VARYING", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("CLOB", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("DATE", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("DECIMAL", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("DOUBLE PRECISION", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("FLOAT", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("INT", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("INTEGER", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("INTERVAL DAY TO SECOND", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("INTERVAL YEAR TO MONTH", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("LONG", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("LONG RAW", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("LONG VARCHAR", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NATIONAL CHAR", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NATIONAL CHAR VARYING", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NATIONAL CHARACTER", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NATIONAL CHARACTER VARYING", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NCHAR", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NCHAR VARYING", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NCLOB", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("NUMBER", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("NUMERIC", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("NVARCHAR2", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("RAW", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("REAL", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("ROWID", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("SMALLINT", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("TIMESTAMP", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("TIMESTAMP WITH LOCAL TIME ZONE", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("TIMESTAMP WITH TIME ZONE", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("UROWID", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("VARCHAR", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("VARCHAR2", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
    }};

    //pgsql所有字段类型
    public static final Set<String> PGSQL_SET = new HashSet<String>() {{
        add("bit");
        add("bool");
        add("box");
        add("bytea");
        add("char");
        add("cidr");
        add("circle");
        add("date");
        add("decimal");
        add("float4");
        add("float8");
        add("inet");
        add("int2");
        add("int4");
        add("int8");
        add("interval");
        add("json");
        add("jsonb");
        add("line");
        add("lseg");
        add("macaddr");
        add("money");
        add("path");
        add("point");
        add("polygon");
        add("serial2");
        add("serial4");
        add("serial8");
        add("text");
        add("time");
        add("set");
        add("smallint");
        add("text");
        add("time");
        add("timestamp");
        add("timestamptz");
        add("timetz");
        add("tsquery");
        add("tsvector");
        add("txid_snapshot");
        add("uuid");
    }};
    //pgsql的日期字段类型
    public static final Set<String> PGSQL_DATE_SET = new HashSet<String>() {{
        add("date");
        add("time");
        add("timestamp");
        add("timestamptz");
        add("timetz");
    }};
    //pgsql字段类型
    public static final Map<String, String> PGSQL_DATA_TYPE_MAP = new HashMap<String, String>() {{
        put("bit", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("bool", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("box", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("bytea", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("char", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("cidr", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("circle", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("date", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("decimal", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("float4", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("float8", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("inet", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("int2", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("int4", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("int8", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("interval", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("json", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("jsonb", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("line", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("lseg", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("macputr", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("money", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("path", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("point", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("polygon", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("serial2", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("serial4", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("serial8", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("text", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("time", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("set", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("smallint", RequestKeyUtils.QUERY_VALUE_TYPR_INT);
        put("timestamp", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("timestamptz", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("timetz", RequestKeyUtils.QUERY_VALUE_TYPR_DATE);
        put("tsquery", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("tsvector", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("txid_snapshot", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
        put("uuid", RequestKeyUtils.QUERY_VALUE_TYPR_STRING);
    }};

    //自定义查询的key包含时间的key
    public static final Set<String> QUERY_DATE_SET = new HashSet<String>() {{
        add("startTime");
        add("endTime");
        add("taskClaimTime");
        add("procDueTime");
        add("startTime_todo");
        add("startTime_complete");
    }};
    //自定义查询的key包含时间 转换
    public static final Map<String, String> QUERY_DATE_MAP_COMMOM = new HashMap<String, String>() {{
        put("startTime", "startTime");
        put("endTime", "endTime");
        put("procDueTime", "procDueTime");
        put("startTime_todo", "startTime");
        put("startTime_complete", "startTime");
    }};

    //数据库返回的时间类型的别名
    public static final Set<String> COLUMN_ALIAS_DATE_SET = new HashSet<String>() {{
        add("startTime");
        add("endTime");
        add("claimTime");
        add("procDueTime");
        add("taskDueDate");
    }};

    @Value("${mybatis.databaseType}")
    private String databaseType;

    public String getDataBaseType() {
        return databaseType;
    }

    // 获取数据库所有字段
    public Set<String> getDataCloumnType() {
        if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
            return DatabaseTypeUtils.MYSQL_SET;
        } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
            return DatabaseTypeUtils.ORACLE_SET;
        } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
            return DatabaseTypeUtils.PGSQL_SET;
        }
        return new HashSet<>();
    }

    //列的字段是否为日期类型
    public static boolean isDateOfCloumnType(String databaseType, String CloumnAllas) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeMap.get(CloumnAllas);
        if (StringUtils.isNotBlank(ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATE_SET.contains(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATE_SET.contains(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATE_SET.contains(ColumnType);
            }
        }
        return false;
    }

    //列的字段是否为日期类型
    public static boolean isDateOfCloumnTypeByCloumnName(String databaseType, String CloumnName) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeByNameMap.get(CloumnName);
        if (StringUtils.isNotBlank(ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATE_SET.contains(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATE_SET.contains(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATE_SET.contains(ColumnType);
            }
        }
        return false;
    }

    //普通查询列的字段是否为日期类型
    public static boolean isDateOfCommonCloumnType(String CloumnAllas) {
        return QUERY_DATE_SET.contains(CloumnAllas);
    }

    //根据数据库类型转换date为 String类型
    public static String toCharCloumnType(String databaseType, String cloumnName) {
        if (StringUtils.isNotBlank(cloumnName)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return "str_to_date(" + cloumnName + ",'%Y-%m-%d')";
            } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return "to_char(" + cloumnName + ",'yyyy-MM-dd HH24:mi:ss')";
            } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return "to_char(" + cloumnName + ", 'HH24:MI:SS')";
            }
        } else {
            throw new NullPointerException(cloumnName + " 不可以为空！");
        }
        return null;
    }

    //根据数据库类型转换string为 date类型
    public static String toDateCloumnType(String databaseType, String cloumnName) {
        if (StringUtils.isNotBlank(cloumnName)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return "date_format( " + cloumnName + " ,'%Y-%m-%d')";
            } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return "to_date( " + cloumnName + " ,'yyyy-MM-dd HH24:mi:ss')";
            } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return "to_date( " + cloumnName + " , 'HH24:MI:SS')";
            }
        } else {
            throw new NullPointerException(cloumnName + " 不可以为空！");
        }
        return null;
    }


    public static String boolDataType(String queryKey, String databaseType) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeMap.get(queryKey);

        if (StringUtils.isNotBlank(ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATA_TYPE_MAP.get(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATA_TYPE_MAP.get(ColumnType);
            } else if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATA_TYPE_MAP.get(ColumnType);
            }
        }
        return null;
    }


}
