package cn.gtmap.gtc.workflow.enums.manage;

/**
 * Created by hhuu on 2019/2/15.
 */
public enum ProcStatus {

    RUNNING(1, "正在运行中"),

    END(2, "结束"),

    SUSPEND(3,"挂起"),

    ABANDON(4, "废弃");

    private Integer value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    ProcStatus(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public static String getStatusName(Integer status){
        if (status == null) {
            return null;
        }
        switch (status){
            case 1:
                return "运行中";
            case 2:
                return "结束";
            case 3:
                return "挂起";
            case 4:
                return "废弃";
        }
        return null;
    }

    public static String getStatusName(String status){

        if ("1".equals(status)) {
            return "运行中";
        } else if ("2".equals(status)) {
            return "结束";
        }else if ("3".equals(status)) {
            return "挂起";
        }else if ("4".equals(status)) {
            return "废弃";
        }
        return null;
    }

}
