package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.ProcessDefData;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2019/2/12
 * @description 获取流程定义
 */

@FeignClient(name = "${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessDefinitionClient {

    /**
     * 根据登录用户id获取所有流程定义
     * @param userId 用户id
     * @param pageable
     * @return
     */
    @GetMapping("/process-definitions/{userId}/list")
    Page<ProcessDefData> processDefDataListPage(@PathVariable("userId") String userId, Pageable pageable);

    /**
     * 根据登录用户id获取所有流程定义list
     * @param userId
     * @return
     */
    @GetMapping("/process-definitions/{userId}/user-procDef")
    List<ProcessDefData> getProcessDefDataByUserId(@PathVariable("userId") String userId);

    /**
     * 根据流程实例ID获取流程定义
     * @param processInstanceId 流程实例ID
     * @return
     */
    @GetMapping("/process-definitions/{processInstanceId}/processDefinition")
    ProcessDefData getProcessDefData(@PathVariable("processInstanceId") String processInstanceId);


    /**
     * 根据业务分类查询所有已发布的流程,排除锁定流程
     * @param categoryKey 业务分类
     * @return 返回流程数据
     */
    @GetMapping("/process-definitions/procDef/category")
    List<ProcessDefData> getProcessDefDataForCategory(@RequestParam(name = "categoryKey",required = false) String categoryKey);

    /**
     * 获取所有已经发布的最新版本的流程定义
     * @return
     */
    @RequestMapping("/process-definitions/all-procDef")
    List<ProcessDefData> getAllProcessDefData();


    /**
     * 获取所有已经发布的最新版本的流程定义包含锁定流程
     */
    @GetMapping("/process-definitions/all/all-procDef")
    List<ProcessDefData> getAllProcessDefDataIncludeSuspend();



    /**
     * 根据processDefKey，查询最新的流程定义
     * @return
     */
    @GetMapping(value = "/process-definitions/definition-key")
    ProcessDefData getProcessDefByProcessDefKey(@RequestParam("processDefKey") String processDefKey);

}
