package cn.gtmap.gtc.workflow.enums.variable;

/**
 * @author <a href="mailto:xuchao@gtmap.cn">xuchao</a>
 * @version 1.0.2019/3/1
 * @description 表单属性key配置
 */
public enum CustomActivityProperty {
    AFTER_CREATE_CHECK_URL("AFTER_CREATE_CHECK_URL","创建后验证地址"),
    AFTER_CREATE_METHOD_TYPE("AFTER_CREATE_CHECK_URL_METHOD","创建后方法类型"),
    AFTER_CREATE_CHECK_URL_REQUEYSTBODY("AFTER_CREATE_CHECK_URL_REQUEYSTBODY","创建后方法请求体"),
    BACK_COMPENSATION_URL("BACK_COMPENSATION_URL","补偿服务地址"),
    BACK_COMPENSATION_URL_METHOD("BACK_COMPENSATION_URL_METHOD","补偿方法类型"),
    BACK_COMPENSATION_URL_REQUEYSTBODY("BACK_COMPENSATION_URL_REQUEYSTBODY","补偿请求体"),
    PROCESS_CREATE_NUMBER_LIMIT("PROCESS_CREATE_NUMBER_LIMIT","流程创建次数"),
    IS_SIGN("IS_SIGN","是否签名"),
    IS_BACK("IS_BACK","是否允许回退"),
    IS_BACK_TO_FIRST("IS_BACK_TO_FIRST","是否允许回退首节点"),
    IS_PLATFORM_VERIFY("IS_PLATFORM_VERIFY", "是否平台验证"),
    IS_END("IS_END","是否允许办结"),
    IS_BIND_START_USER("IS_BIND_START_USER","是否绑定初始节点用户"),
    BIND_OTHER_NODE_USER("BIND_OTHER_NODE_USER","绑定节点用户"),
    NODE_SORT("NODE_SORT","节点顺序"),
    SAME_PEOPLE_ACTIVITY_ID("SAME_PEOPLE_ACTIVITY_ID","相同办理节点"),
    DNEXT_DISPATCH_STATEGY("DNEXT_DISPATCH_STATEGY","下节点派件策略"),
    IGNORE_REQUEST_EXCEPTION("IGNORE_REQUEST_EXCEPTION","忽略异常响应"),

    END_URL("END_URL","办结服务地址"),
    END_URL_METHOD("END_URL_METHOD","办结服务方法类型"),
    END_URL_REQUEYSTBODY("END_URL_REQUEYSTBODY","办结服务请求体"),

    BEFORE_FORWARD_URL("BEFORE_FORWARD_URL","转发前验证地址"),
    BEFORE_FORWARD_URL_METHOD("BEFORE_FORWARD_URL_METHOD","转发前方法类型"),
    BEFORE_FORWARD_URL_REQUEYSTBODY("BEFORE_FORWARD_URL_REQUEYSTBODY","转发前验证请求体"),

    CUSTOM_ISEND_CUSTOM_URL("CUSTOM_ISEND_CUSTOM_URL","是否允许办结业务验证URL"),
    CUSTOM_ISEND_CUSTOM_URL_METHOD("CUSTOM_ISEND_CUSTOM_URL_METHOD","是否允许办结业务方法验证类型"),
    CUSTOM_ISEND_CUSTOM_URL_REQUEYSTBODY("CUSTOM_ISEND_CUSTOM_URL_REQUEYSTBODY","是否允许办结业务验证请求体"),


    CUSTOM_REGION_FILTER_URL("CUSTOM_REGION_FILTER_URL","业务行政区编码过滤验证地址"),
    CUSTOM_REGION_FILTER_METHOD("CUSTOM_REGION_FILTER_METHOD","业务行政区编码过滤验证方法"),

    CUSTOM_ROLE_FILTER_URL("CUSTOM_ROLE_FILTER_URL","业务角色过滤验证地址"),

    CUSTOM_ROLE_FILTER_METHOD("CUSTOM_ROLE_FILTER_METHOD","业务角色过滤验证方法"),
    CUSTOM_NODE_AUTOCOMPLETE_URL("CUSTOM_NODE_AUTOCOMPLETE_URL","业务节点自动转发地址"),
    CUSTOM_NODE_AUTOCOMPLETE_METHOD("CUSTOM_NODE_AUTOCOMPLETE_METHOD","业务节点自动转发方法"),


    CUSTOM_BIND_NODE_USER_URL("CUSTOM_BIND_NODE_USER_URL","业务自定义人员事件"),

    CUSTOM_BIND_NODE_USER_METHOD("CUSTOM_BIND_NODE_USER_METHOD","业务自定义人员请求METHOD"),

    BEFORE_DELETE_URL("BEFORE_DELETE_URL","删除前验证地址"),
    BEFORE_DELETE_URL_METHOD("BEFORE_DELETE_URL_METHOD","删除前方法类型"),
    BEFORE_DELETE_URL_REQUEYSTBODY("BEFORE_DELETE_URL_REQUEYSTBODY","删除前验证请求体"),

    ABANDONED_URL("ABANDONED_URL","废弃服务地址"),
    ABANDONED_URL_METHOD("ABANDONED_URL_METHOD","废弃服务方法类型"),
    DEFAULT_RECEIVER("DEFAULT_RECEIVER","默认的受理人"),
    AUTO_COMPLETE_USER_TYPE("AUTO_COMPLETE_USER_TYPE","自动转发受理人员"),
    IS_AUTO_COMPLETE_NODE("IS_AUTO_COMPLETE_NODE","是否自动转发"),
    IS_DEFAULT_FORWARDING_NODE("IS_DEFAULT_FORWARDING_NODE","是否默认转发节点"),
    IS_IN_CHARGE_NODE("IS_IN_CHARGE_NODE","是否分管节点"),
    IS_DEPARTMENT_FILTER_FORWARDING_NODE("IS_DEPARTMENT_FILTER_FORWARDING_NODE","是否部门过滤转发节点"),

    DEPARTMENT_FILTER_FOR_DEPARTMENT_CODE("DEPARTMENT_FILTER_FOR_DEPARTMENT_CODE","当前部门编码下才进行部门过滤"),


    CLAIM_FILTER_FOR_REGION_CODE("CLAIM_FILTER_FOR_REGION_CODE","认领自己转发的任务区县限制"),

    DISPATCH_REGION_CODE("DISPATCH_REGION_CODE","自动派件开启区县"),

    IS_DEPARTMENT_FILTER_START_USER_NODE("IS_DEPARTMENT_FILTER_START_USER_NODE","是否首节点部门过滤节点"),


    IS_NEXT_NODE_FILTER_MY("IS_NEXT_NODE_FILTER_MY","是否过滤自己"),


    IS_DEPARTMENT_FILTER_CLAIM_NODE("IS_DEPARTMENT_FILTER_CLAIM_NODE","同部门认领节点")

    ;

    private String value;
    private String label;

    private CustomActivityProperty(String value, String label){
        this.value = value;
        this.label = label;
    }

    public static CustomActivityProperty valueOf(int value) {
        for (CustomActivityProperty customActivityKey : values()) {
            if (customActivityKey.getValue().equals(value)) {
                return customActivityKey;
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }
}
