package cn.gtmap.gtc.workflow.domain.manage;

import java.io.Serializable;
import java.util.Map;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/6/11
 * @Description: 流程定义实体
 *
 */

@SuppressWarnings("serial")
public class ProcessDefData implements Serializable{

    private static final long serialVersionUID = 1L;
    //流程定义id
    protected String id;
    //流程定义名称
    protected String name;
    protected String description;
    //流程定义key
    protected String key;
    //流程定义版本
    protected int version;
    //流程定义类型名称
    protected String category;

    protected Map<String, Object> variables;

    protected int suspensionState ;
    //流程定义key,查询新建任务
    private String processDefKey;

    /**
     * 常用标识  0：否  1：是 (流程定义收藏标识)
     */
    private Integer commonUse;

    private Integer modelSort;

    public Integer getCommonUse() {
        return commonUse;
    }

    public ProcessDefData setCommonUse(Integer commonUse) {
        this.commonUse = commonUse;
        return this;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }


    public String getId() {
        return id;
    }

    public ProcessDefData setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public ProcessDefData setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public ProcessDefData setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getKey() {
        return key;
    }

    public ProcessDefData setKey(String key) {
        this.key = key;
        return this;
    }

    public int getVersion() {
        return version;
    }

    public ProcessDefData setVersion(int version) {
        this.version = version;
        return this;
    }

    public String getCategory() {
        return category;
    }

    public ProcessDefData setCategory(String category) {
        this.category = category;
        return this;
    }

    public Map<String, Object> getVariables() {
        return variables;
    }

    public ProcessDefData setVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public int getSuspensionState() {
        return suspensionState;
    }

    public ProcessDefData setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
        return this;
    }

    public String getProcessDefKey() {
        return processDefKey;
    }

    public ProcessDefData setProcessDefKey(String processDefKey) {
        this.processDefKey = processDefKey;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ProcessDefData that = (ProcessDefData) o;

        if (id != null ? !id.equals(that.id) : that.id != null) {
            return false;
        }

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        return result;
    }

    public Integer getModelSort() {
        if (modelSort == null){
            return Integer.MAX_VALUE;
        }
        return modelSort;
    }

    public void setModelSort(Integer modelSort) {
        this.modelSort = modelSort;
    }

    @Override
    public String toString() {
        return "ProcessDefData{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", key='" + key + '\'' +
                ", version=" + version +
                ", category='" + category + '\'' +
                ", variables=" + variables +
                ", suspensionState=" + suspensionState +
                ", processDefKey='" + processDefKey + '\'' +
                ", commonUse=" + commonUse +
                ", modelSort=" + modelSort +
                '}';
    }
}
