package cn.gtmap.gtc.workflow.domain.manage;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author xzw
 * @Date 2023/12/20 16:11
 * @PackageName:cn.gtmap.gtc.workflow.domain.manage
 * @ClassName: AutoCompleteInfo
 * @Description: 指定自动转发对象
 */
public class AutoCompleteInfo implements Serializable {


    private static final long serialVersionUID = 1L;

    /**
     * 流程实例id
     */
    private String processInsId;

    /**
     * 当前任务id
     */
    private String currentTaskId;

    /**
     * 转发开始执行时间
     */
    private Date firstCompleteDate;

    /**
     * 转发对象
     */
    private List<CompleteNodeUser> completeNodeUserList;

    public Date getFirstCompleteDate() {
        return firstCompleteDate;
    }

    public void setFirstCompleteDate(Date firstCompleteDate) {
        this.firstCompleteDate = firstCompleteDate;
    }

    public String getProcessInsId() {
        return processInsId;
    }

    public void setProcessInsId(String processInsId) {
        this.processInsId = processInsId;
    }

    public String getCurrentTaskId() {
        return currentTaskId;
    }

    public void setCurrentTaskId(String currentTaskId) {
        this.currentTaskId = currentTaskId;
    }


    public List<CompleteNodeUser> getCompleteNodeUserList() {
        return completeNodeUserList;
    }

    public void setCompleteNodeUserList(List<CompleteNodeUser> completeNodeUserList) {
        this.completeNodeUserList = completeNodeUserList;
    }

    public String getCurrentNodeName() {
        for (int i = 0; i < this.completeNodeUserList.size(); i++) {
            CompleteNodeUser  completeNodeUser = completeNodeUserList.get(i);
            if (!completeNodeUser.isCompleted()){
                if (i == 0){
                    return null;
                }else {
                   return completeNodeUserList.get(i -1).getNodeName();
                }
            }
        }
        return null;
    }

    public String getNextNodeName() {
        for (int i = 0; i < this.completeNodeUserList.size(); i++) {
            CompleteNodeUser  completeNodeUser = completeNodeUserList.get(i);
            if (!completeNodeUser.isCompleted()){
               return completeNodeUser.getNodeName();
            }
        }
        return null;
    }

    public String getNextNodeUser() {
        for (int i = 0; i < this.completeNodeUserList.size(); i++) {
            CompleteNodeUser  completeNodeUser = completeNodeUserList.get(i);
            if (!completeNodeUser.isCompleted()){
                return completeNodeUser.getUserName();
            }
        }
        return null;
    }

    public String getEndNodePreNodeName() {
        return this.completeNodeUserList.size() > 1 ? this.completeNodeUserList.get(this.completeNodeUserList.size() - 2).getNodeName():null;
    }

    public String getEndNodeName() {
        return this.completeNodeUserList.get(this.completeNodeUserList.size() - 1).getNodeName();
    }


    public void init(String name,boolean init) {
        for (int i = 0; i < this.completeNodeUserList.size(); i++) {
            CompleteNodeUser completeNodeUser = completeNodeUserList.get(i);
            if (completeNodeUser.isCompleted()){
                continue;
            }
            if (init){
                completeNodeUser.setCompleted(true);
            }
            // 找到第一个匹配数据,设置转发状态,退出循环
             if (StringUtils.equals(completeNodeUser.getNodeName(),name)){
                completeNodeUser.setCompleted(true);
                break;
            }
        }
    }
}
