package cn.gtmap.gtc.workflow.domain.common;

import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 请求条件
 */
public class RequestCondition implements Serializable{


    private static final long serialVersionUID = 2191686698573151533L;

    private String requestKey;          //请求的字段值 参考 enum  TaskQueryKey（的字段）

    private String requestJudge;        //请求的判断条件 参考 enum QueryJudge值

    private Object requestValue;        //请求的属性值

    public String getRequestKey() {
        return requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public String getRequestJudge() {
        if (StringUtils.isEmpty(requestJudge)){
            return "";
        }
        return requestJudge.trim();
    }

    public void setRequestJudge(String requestJudge) {
        this.requestJudge = requestJudge;
    }

    public Object getRequestValue() {
        if(requestValue instanceof String && StringUtils.isEmpty(requestValue.toString())){
            return "";
        }else if(requestValue instanceof String && !StringUtils.isEmpty(requestValue.toString())){
            return requestValue.toString().trim();
        }
        return requestValue;
    }

    public void setRequestValue(Object requestValue) {
        this.requestValue = requestValue;
    }
}
