package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author Fjj
 * @date 2019/1/2
 */
@FeignClient(name = "${app.services.bpm-manage:bpm-manage}")
@RequestMapping("/manage/v1")
public interface SimpleProcessClient {

    /**
     * 后台创建流程
     *
     * @param processKey
     * @param vars
     * @return
     */
    @PostMapping(value = "/simple-process/create-process")
    String createProcess(@RequestParam(value = "processKey") String processKey,
                         @RequestParam(value = "businessKey") String businessKey, @RequestBody Map vars);

    /**
     * 查询流程实例的任务列表
     *
     * @param processInstanceId
     * @param taskKey
     * @return
     */
    @GetMapping(value = "/simple-process/process-instances/{id}/tasks")
    List<RuTaskDto> getTaskList(@PathVariable(value = "id") String processInstanceId,
                                @RequestParam(value = "taskKey", required = false, defaultValue = "") String taskKey);

    /**
     * 转发流程
     *
     * @param taskId
     * @param data
     * @return
     */
    @PostMapping(value = "/simple-process/tasks/{id}/transfer")
    void transferProcess(@PathVariable(value = "id") String taskId,
                         @RequestBody TransferData data);

    /**
     * 根据任务ID终止流程
     *
     * @param taskId
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/simple-process/tasks/{id}/end")
    void endProcessByTaskId(@PathVariable(value = "id") String taskId, @RequestBody TransferData data);

    /**
     * 查询任务关联流程的businessKey
     *
     * @param taskId
     * @return
     */
    @GetMapping("/simple-process/tasks/{id}/business-key")
    public String findBusinessKeyByTaskId(@PathVariable(name = "id") String taskId);

    /**
     * 流程退回
     *
     * @param taskId
     * @param data
     */
    @PostMapping(value = "/simple-process/tasks/{id}/back")
    void backProcess(@PathVariable("id") String taskId,
                     @RequestBody BackData data);


    /**
     * 根据任务Id和属性key查询属性数据
     * @param taskId
     * @param varKey
     * @return
     */
    @GetMapping(value = "/simple-process/tasks/{taskId}/task-vars")
    public Object getProcessVarsByTaskIdAndVarkey(@PathVariable(value = "taskId")String taskId,
                                                  @RequestParam("varKey") String varKey);


    /**
     * 查询流程实例的任务列表
     *
     * @param processInstanceId
     * @param taskKey
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/simple-process/process-instances/{id}/task-keys/{key}/id")
    String getTaskId(@PathVariable(value = "id") String processInstanceId,
                     @PathVariable(value = "key") String taskKey);

    /**
     * 根据流程的ID获取历史任务及其局部的属性
     */
    @GetMapping("/simple-process/process-instances/{id}/history-tasks")
    List<HiTaskInstDetail> getProcessHistory(@PathVariable(value = "id") String processInstanceId);

    /**
     * 分页查询含有特定变量的流程实例
     *
     * @param vars
     * @param page
     * @param size
     */
    @PostMapping(value = "/simple-process/his-process-instances/by-vars/page")
    Page<HistoricProcessInstance> queryHisProcessByVarsAndPage(@RequestBody Map vars, @RequestParam("page") int page, @RequestParam("size") int size);

    /**
     * 查询含有特定变量的流程实例
     *
     * @param vars
     */
    @PostMapping(value = "/simple-process/his-process-instances/by-vars")
    List<HistoricProcessInstance> queryHisProcessByVars(@RequestBody Map vars);

}
