package cn.gtmap.gtc.workflow.clients.define.v2;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.workflow.domain.define.ProcessModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhouk
 * @Title: ProcessModelClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/9/2617:31
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v2")
public interface ProcessModelClient {

    @RequestMapping(
            value = {"/process-models"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public PageResult<ProcessModel> queryProcessModels(@RequestParam(required = false,value = "filter") String filter,
                                                       @RequestParam(required = false,value = "statusKey") String statusKey,
                                                       @RequestParam(required = false,value = "userName") String userName,
                                                       @RequestParam("modelType") Integer modelType, Pageable pageable);


    /**
     * 根据条件查询流程定义信息
     * @param name 名称
     * @param category 业务分类
     * @param statusKey 流程定义状态
     * @param userName 创建人员
     * @param modelType 流程类型
     * @return 返回对应的流程定义信息
     */
    @RequestMapping(value = "/list/process-model",method = RequestMethod.GET)
    List<ProcessModel> queryProcessModelsByCondition(@RequestParam(required = false,value = "name") String name,
                                                            @RequestParam(required = false,value = "category") String category,
                                                            @RequestParam(required = false,value = "statusKey") String statusKey,
                                                            @RequestParam(required = false,value = "userName") String userName,
                                                            @RequestParam(value = "modelType",required = false) Integer modelType);
}
