/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils.manager;

import cn.gtmap.gtc.workflow.utils.manager.ProjectExtendConfigUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class DatabaseTypeUtils {
    public static final String DATABASE_TYPE_MYSQL = "mysql";
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_PGSQL = "postgresql";
    public static final Set<String> MYSQL_SET = new HashSet<String>(){
        {
            this.add("bigint");
            this.add("binary");
            this.add("bit");
            this.add("blob");
            this.add("char");
            this.add("date");
            this.add("datetime");
            this.add("decimal");
            this.add("double");
            this.add("enum");
            this.add("float");
            this.add("geometry");
            this.add("geometrycollection");
            this.add("int");
            this.add("integer");
            this.add("longtext");
            this.add("linestring");
            this.add("longblob");
            this.add("json");
            this.add("mediumblob");
            this.add("mediumblob");
            this.add("mediumint");
            this.add("mediumtext");
            this.add("multilinestring");
            this.add("multipoint");
            this.add("multipolygon");
            this.add("numeric");
            this.add("point");
            this.add("polygon");
            this.add("real");
            this.add("set");
            this.add("smallint");
            this.add("text");
            this.add("time");
            this.add("timestamp");
            this.add("tinyblob");
            this.add("tinyint");
            this.add("tinytext");
            this.add("varbinary");
            this.add("varchar");
            this.add("year");
        }
    };
    public static final Set<String> MYSQL_DATE_SET = new HashSet<String>(){
        {
            this.add("date");
            this.add("datetime");
            this.add("time");
            this.add("timestamp");
            this.add("year");
        }
    };
    public static final Map<String, String> MYSQL_DATA_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("bigint", "number");
            this.put("binary", "number");
            this.put("bit", "number");
            this.put("blob", "string");
            this.put("char", "string");
            this.put("date", "date");
            this.put("datetime", "date");
            this.put("decimal", "number");
            this.put("double", "number");
            this.put("enum", "number");
            this.put("float", "string");
            this.put("geometry", "string");
            this.put("geometrycollection", "string");
            this.put("int", "number");
            this.put("integer", "number");
            this.put("longtext", "string");
            this.put("linestring", "string");
            this.put("longblob", "string");
            this.put("json", "string");
            this.put("mediumblob", "string");
            this.put("mediumblob", "string");
            this.put("mediumint", "number");
            this.put("mediumtext", "string");
            this.put("multilinestring", "string");
            this.put("multipoint", "number");
            this.put("multipolygon", "string");
            this.put("numeric", "number");
            this.put("point", "number");
            this.put("polygon", "string");
            this.put("real", "string");
            this.put("set", "string");
            this.put("smallint", "number");
            this.put("text", "string");
            this.put("time", "date");
            this.put("timestamp", "date");
            this.put("tinyblob", "string");
            this.put("tinyint", "number");
            this.put("tinytext", "string");
            this.put("varbinary", "string");
            this.put("varchar", "string");
            this.put("year", "date");
        }
    };
    public static final Set<String> ORACLE_SET = new HashSet<String>(){
        {
            this.add("BFILE");
            this.add("BINARY_DOUBLE");
            this.add("BINARY_FLOAT");
            this.add("BLOB");
            this.add("CHAR");
            this.add("CHAR VARYING");
            this.add("CHARACTER");
            this.add("CHARACTER VARYING");
            this.add("CLOB");
            this.add("DATE");
            this.add("DECIMAL");
            this.add("DOUBLE PRECISION");
            this.add("FLOAT");
            this.add("INT");
            this.add("INTEGER");
            this.add("INTERVAL DAY TO SECOND");
            this.add("INTERVAL YEAR TO MONTH");
            this.add("LONG");
            this.add("LONG RAW");
            this.add("LONG VARCHAR");
            this.add("NATIONAL CHAR");
            this.add("NATIONAL CHAR VARYING");
            this.add("NATIONAL CHARACTER");
            this.add("NATIONAL CHARACTER VARYING");
            this.add("NCHAR");
            this.add("NCHAR VARYING");
            this.add("NCLOB");
            this.add("NUMBER");
            this.add("NUMERIC");
            this.add("NVARCHAR2");
            this.add("RAW");
            this.add("REAL");
            this.add("ROWID");
            this.add("SMALLINT");
            this.add("TIMESTAMP");
            this.add("TIMESTAMP WITH LOCAL TIME ZONE");
            this.add("TIMESTAMP WITH TIME ZONE");
            this.add("UROWID");
            this.add("VARCHAR");
            this.add("VARCHAR2");
        }
    };
    public static final Set<String> ORACLE_DATE_SET = new HashSet<String>(){
        {
            this.add("DATE");
            this.add("TIMESTAMP");
            this.add("TIMESTAMP WITH LOCAL TIME ZONE");
            this.add("TIMESTAMP WITH TIME ZONE");
        }
    };
    public static final Map<String, String> ORACLE_DATA_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("BFILE", "number");
            this.put("BINARY_DOUBLE", "number");
            this.put("BINARY_FLOAT", "number");
            this.put("BLOB", "string");
            this.put("CHAR", "string");
            this.put("CHAR VARYING", "string");
            this.put("CHARACTER", "string");
            this.put("CHARACTER VARYING", "string");
            this.put("CLOB", "string");
            this.put("DATE", "date");
            this.put("DECIMAL", "number");
            this.put("DOUBLE PRECISION", "number");
            this.put("FLOAT", "number");
            this.put("INT", "number");
            this.put("INTEGER", "number");
            this.put("INTERVAL DAY TO SECOND", "date");
            this.put("INTERVAL YEAR TO MONTH", "date");
            this.put("LONG", "string");
            this.put("LONG RAW", "string");
            this.put("LONG VARCHAR", "string");
            this.put("NATIONAL CHAR", "string");
            this.put("NATIONAL CHAR VARYING", "string");
            this.put("NATIONAL CHARACTER", "string");
            this.put("NATIONAL CHARACTER VARYING", "string");
            this.put("NCHAR", "string");
            this.put("NCHAR VARYING", "string");
            this.put("NCLOB", "string");
            this.put("NUMBER", "number");
            this.put("NUMERIC", "number");
            this.put("NVARCHAR2", "string");
            this.put("RAW", "string");
            this.put("REAL", "number");
            this.put("ROWID", "string");
            this.put("SMALLINT", "number");
            this.put("TIMESTAMP", "date");
            this.put("TIMESTAMP WITH LOCAL TIME ZONE", "date");
            this.put("TIMESTAMP WITH TIME ZONE", "date");
            this.put("UROWID", "string");
            this.put("VARCHAR", "string");
            this.put("VARCHAR2", "string");
        }
    };
    public static final Set<String> PGSQL_SET = new HashSet<String>(){
        {
            this.add("bit");
            this.add("bool");
            this.add("box");
            this.add("bytea");
            this.add("char");
            this.add("cidr");
            this.add("circle");
            this.add("date");
            this.add("decimal");
            this.add("float4");
            this.add("float8");
            this.add("inet");
            this.add("int2");
            this.add("int4");
            this.add("int8");
            this.add("interval");
            this.add("json");
            this.add("jsonb");
            this.add("line");
            this.add("lseg");
            this.add("macaddr");
            this.add("money");
            this.add("path");
            this.add("point");
            this.add("polygon");
            this.add("serial2");
            this.add("serial4");
            this.add("serial8");
            this.add("text");
            this.add("time");
            this.add("set");
            this.add("smallint");
            this.add("text");
            this.add("time");
            this.add("timestamp");
            this.add("timestamptz");
            this.add("timetz");
            this.add("tsquery");
            this.add("tsvector");
            this.add("txid_snapshot");
            this.add("uuid");
        }
    };
    public static final Set<String> PGSQL_DATE_SET = new HashSet<String>(){
        {
            this.add("date");
            this.add("time");
            this.add("timestamp");
            this.add("timestamptz");
            this.add("timetz");
        }
    };
    public static final Map<String, String> PGSQL_DATA_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("bit", "number");
            this.put("bool", "number");
            this.put("box", "number");
            this.put("bytea", "string");
            this.put("char", "string");
            this.put("cidr", "number");
            this.put("circle", "number");
            this.put("date", "date");
            this.put("decimal", "number");
            this.put("float4", "number");
            this.put("float8", "number");
            this.put("inet", "number");
            this.put("int2", "number");
            this.put("int4", "number");
            this.put("int8", "number");
            this.put("interval", "date");
            this.put("json", "date");
            this.put("jsonb", "date");
            this.put("line", "number");
            this.put("lseg", "number");
            this.put("macputr", "number");
            this.put("money", "number");
            this.put("path", "number");
            this.put("point", "number");
            this.put("polygon", "number");
            this.put("serial2", "number");
            this.put("serial4", "number");
            this.put("serial8", "number");
            this.put("text", "string");
            this.put("time", "date");
            this.put("set", "number");
            this.put("smallint", "number");
            this.put("timestamp", "date");
            this.put("timestamptz", "date");
            this.put("timetz", "date");
            this.put("tsquery", "string");
            this.put("tsvector", "string");
            this.put("txid_snapshot", "string");
            this.put("uuid", "string");
        }
    };
    public static final Set<String> QUERY_DATE_SET = new HashSet<String>(){
        {
            this.add("startTime");
            this.add("endTime");
            this.add("procDueTime");
            this.add("startTime_todo");
            this.add("startTime_complete");
        }
    };
    public static final Map<String, String> QUERY_DATE_MAP_COMMOM = new HashMap<String, String>(){
        {
            this.put("startTime", "startTime");
            this.put("endTime", "endTime");
            this.put("procDueTime", "procDueTime");
            this.put("startTime_todo", "startTime");
            this.put("startTime_complete", "startTime");
        }
    };
    public static final Set<String> COLUMN_ALIAS_DATE_SET = new HashSet<String>(){
        {
            this.add("startTime");
            this.add("endTime");
            this.add("claimTime");
            this.add("procDueTime");
            this.add("taskDueDate");
        }
    };
    @Value(value="${mybatis.databaseType}")
    private String databaseType;

    public String getDataBaseType() {
        return this.databaseType;
    }

    public Set<String> getDataCloumnType() {
        if (this.databaseType.equals(DATABASE_TYPE_MYSQL)) {
            return MYSQL_SET;
        }
        if (this.databaseType.equals(DATABASE_TYPE_ORACLE)) {
            return ORACLE_SET;
        }
        if (this.databaseType.equals(DATABASE_TYPE_PGSQL)) {
            return PGSQL_SET;
        }
        return new HashSet<String>();
    }

    public static boolean isDateOfCloumnType(String databaseType, String CloumnAllas) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeMap.get(CloumnAllas);
        if (StringUtils.isNotBlank((CharSequence)ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATE_SET.contains(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATE_SET.contains(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATE_SET.contains(ColumnType);
            }
        }
        return false;
    }

    public static boolean isDateOfCloumnTypeByCloumnName(String databaseType, String CloumnName) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeByNameMap.get(CloumnName);
        if (StringUtils.isNotBlank((CharSequence)ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATE_SET.contains(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATE_SET.contains(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATE_SET.contains(ColumnType);
            }
        }
        return false;
    }

    public static boolean isDateOfCommonCloumnType(String CloumnAllas) {
        return QUERY_DATE_SET.contains(CloumnAllas);
    }

    public static String toCharCloumnType(String databaseType, String cloumnName) {
        if (StringUtils.isNotBlank((CharSequence)cloumnName)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return "str_to_date(" + cloumnName + ",'%Y-%m-%d')";
            }
            if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return "to_char(" + cloumnName + ",'yyyy-MM-dd HH24:mi:ss')";
            }
            if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return "to_char(" + cloumnName + ", 'HH24:MI:SS')";
            }
        } else {
            throw new NullPointerException(cloumnName + " \u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        return null;
    }

    public static String toDateCloumnType(String databaseType, String cloumnName) {
        if (StringUtils.isNotBlank((CharSequence)cloumnName)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return "date_format( " + cloumnName + " ,'%Y-%m-%d')";
            }
            if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return "to_date( " + cloumnName + " ,'yyyy-MM-dd HH24:mi:ss')";
            }
            if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return "to_date( " + cloumnName + " , 'HH24:MI:SS')";
            }
        } else {
            throw new NullPointerException(cloumnName + " \u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        return null;
    }

    public static String boolDataType(String queryKey, String databaseType) {
        String ColumnType = ProjectExtendConfigUtils.ProjectExtendConfigCloumnTypeMap.get(queryKey);
        if (StringUtils.isNotBlank((CharSequence)ColumnType)) {
            if (databaseType.equals(DATABASE_TYPE_MYSQL)) {
                return MYSQL_DATA_TYPE_MAP.get(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_ORACLE)) {
                return ORACLE_DATA_TYPE_MAP.get(ColumnType);
            }
            if (databaseType.equals(DATABASE_TYPE_PGSQL)) {
                return PGSQL_DATA_TYPE_MAP.get(ColumnType);
            }
        }
        return null;
    }
}

