package cn.gtmap.gtc.workflow.utils.manager;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.enums.manage.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * @Classname cn.gtmap.gtc.workflow.manage.utils
 * @Description 任务扩展属性的请求条件工具类
 * @Date 2020/3/25 16:32
 * @Created by zhouk
 */
public class RequestConditionUtils {

    private static final Logger logger = LoggerFactory.getLogger(RequestConditionUtils.class);

    //项目的默认排序sql
    private static final String PROCESS_DEFLAT_ORDER_SQL = "  ORDER BY  sprc.PRIORITY, hpi.START_TIME_ DESC ";

    /**
     * 任务的拼接sql
     *
     * @param taskPrefix
     * @param taskSuffix
     * @param requestConditions
     * @param params
     * @return
     */
    public static String spliceTaskExtendSql(String taskPrefix, String taskSuffix, String defaultOrder, List<RequestCondition> requestConditions,
                                             Map<String, Object> params, String databaseType) {
        return spliceTaskExtendSql(taskPrefix, taskSuffix, defaultOrder, ProjectSearchSql.COMMON_WHERE_SQL, requestConditions, params, databaseType, null);
    }


    /**
     * 任务的拼接sql
     *
     * @param taskPrefix
     * @param taskSuffix
     * @param requestConditions
     * @param params
     * @return
     */
    public static String spliceTaskExtendSql(String taskPrefix, String taskSuffix, String defaultOrder, String whereCommonSql,
                                             List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType, String whereBaseSql) {
        boolean hasExtendOrder = false;
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            StringBuilder whereSql = new StringBuilder();
            StringBuilder orderSql = new StringBuilder();
            Set<String> whereOrSql = new HashSet<>();

            for (RequestCondition requestCondition : requestConditions) {
                if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
                    //判断是否为常用字段 （QueryKey中包含)
                    boolean isExtend = true;
                    if (RequestKeyUtils.isTaskContains(requestCondition.getRequestKey())) {
                        isExtend = false;
                    }
                    if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        whereSql.append(getCommonOperator(requestCondition, "=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "!=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, ">", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, ">=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "<", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "<=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                        whereSql.append(getCommonLike(requestCondition, isExtend, true));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                        whereSql.append(getCommonIn(requestCondition, isExtend, true));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                        whereSql.append(getCommonSpecialSql(requestCondition));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        if (StringUtils.isNotBlank(orderSql.toString())) {
                            orderSql.append(" ," + getCommonOrder(requestCondition, isExtend, true));
                        } else {
                            orderSql.append(getCommonOrder(requestCondition, isExtend, true));
                        }
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                        whereOrSql.add(getCommonOrOperator(requestCondition, "=", isExtend, true, databaseType, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                        whereOrSql.add(getCommonOrLike(requestCondition, isExtend, true, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                        whereOrSql.add(getCommonOrIn(requestCondition, isExtend, true, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_IN.value())) {
                        whereOrSql.add(getCommonNotIn(requestCondition, isExtend, true, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKES.value())) {
                        whereSql.append(getCommonLikes(requestCondition, isExtend, true));
                    }

                    if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) &&
                            !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                    }
                }
            }
            //如果没有排序，增加默认排序
            if (StringUtils.isBlank(orderSql.toString())) {
                orderSql.append(defaultOrder);
            }
            String whereOrSqlStr = org.springframework.util.StringUtils.collectionToDelimitedString(whereOrSql, " or ");
            if (StringUtils.isNotBlank(whereOrSqlStr)) {
                whereOrSqlStr = " and ( " + whereOrSqlStr + " )";
            }
            String sql = null;
            if (orderSql.length() > 0) {
                String[] orders = orderSql.toString().split(",");
                for (String order : orders) {
                    if (!order.trim().contains("task.")) {
                        hasExtendOrder = true;
                    }
                }
            }
            if (hasExtendOrder) {
                taskSuffix = taskSuffix.replace("${orderBy}", "");
                sql = taskPrefix + getCustomCloumnSql() + taskSuffix + whereCommonSql + whereSql + whereOrSqlStr + " order by " + orderSql;
            } else {
                String orderBy = " order by " + orderSql;
                orderBy = orderBy.replace("task.", "");
                taskSuffix = taskSuffix.replace("${orderBy}", orderBy);
                sql = taskPrefix + getCustomCloumnSql() + taskSuffix + whereCommonSql + whereSql + whereOrSqlStr;
            }

            return sql;
        }
        if (StringUtils.isNotBlank(defaultOrder)) {
            String[] orders = defaultOrder.split(",");
            for (String order : orders) {
                if (!order.trim().contains("task.")) {
                    hasExtendOrder = true;
                }
            }
        }
        if (hasExtendOrder) {
            taskSuffix = taskSuffix.replace("${orderBy}", "");
            return taskPrefix + getCustomCloumnSql() + taskSuffix + whereCommonSql + " order by " + defaultOrder;
        }
        String orderBy = " order by " + defaultOrder;
        orderBy = orderBy.replace("task.", "");
        taskSuffix = taskSuffix.replace("${orderBy}", orderBy);
        return taskPrefix + getCustomCloumnSql() + taskSuffix + whereCommonSql;
    }


    /**
     * 流程的拼接sql
     *
     * @param processPrefix
     * @param processSuffix
     * @param processWhere
     * @param requestConditions
     * @param params
     * @return
     */
    public static String spliceProcessExtendSql(String processPrefix, String processSuffix, String defaultOrder, String processWhere,
                                                List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType, String whereBaseSql) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            StringBuilder whereSql = new StringBuilder();
            StringBuilder orderSql = new StringBuilder();
            Set<String> whereOrSql = new HashSet<>();
            requestConditions.forEach(requestCondition -> {
                if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
                    //判断是否为常用字段 （QueryKey中包含)
                    boolean isExtend = true;
                    if (RequestKeyUtils.isProcContains(requestCondition.getRequestKey())) {
                        isExtend = false;
                    }
                    if (requestCondition.getRequestJudge().equals(QueryJudge.EQUALS.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "!=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, ">", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, ">=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "<", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                        whereSql.append(getCommonOperator(requestCondition, "<=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                        whereSql.append(getCommonLike(requestCondition, isExtend, false));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                        whereSql.append(getCommonIn(requestCondition, isExtend, false));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                        whereSql.append(getCommonSpecialSql(requestCondition));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        if (StringUtils.isNotBlank(orderSql.toString())) {
                            orderSql.append(" ," + getCommonOrder(requestCondition, isExtend, false));
                        } else {
                            orderSql.append(getCommonOrder(requestCondition, isExtend, false));
                        }
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                        whereOrSql.add(getCommonOrOperator(requestCondition, "=", isExtend, false, databaseType, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                        whereOrSql.add(getCommonOrLike(requestCondition, isExtend, false, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                        whereOrSql.add(getCommonOrIn(requestCondition, isExtend, false, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_IN.value())) {
                        whereOrSql.add(getCommonNotIn(requestCondition, isExtend, false, whereBaseSql));
                    }

                    if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) &&
                            !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                    }
                }
            });
            //如果没有排序，增加默认排序
            if (StringUtils.isBlank(orderSql.toString())) {
                orderSql.append(defaultOrder);
            }
            String whereOrSqlStr = org.springframework.util.StringUtils.collectionToDelimitedString(whereOrSql, " or ");
            if (StringUtils.isNotBlank(whereOrSqlStr)) {
                whereOrSqlStr = " and ( " + whereOrSqlStr + " )";
            }
            String sql = processPrefix + getCustomCloumnSql() + processSuffix + processWhere + whereSql + whereOrSqlStr + " order by " + orderSql;
            return sql;
        }
        return processPrefix + getCustomCloumnSql() + processSuffix + processWhere + " order by " + defaultOrder;
    }

    private static String getCommonOrOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType, String whereBaseSql) {
        if (StringUtils.isNotBlank(whereBaseSql)) {
            return getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, null) + whereBaseSql;
        }
        return getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, null);
    }

    private static String getCommonOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType) {
        return getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, "and");
    }

    private static String getCommonOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType, String link) {
        if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
            StringBuilder sql = null;
            if (StringUtils.isEmpty(link)) {
                sql = new StringBuilder();
            } else {
                sql = new StringBuilder(" ").append(link).append(" ");
            }
            boolean isDate = false;
            if (isExtend) {
                if (DatabaseTypeUtils.isDateOfCloumnType(databaseType, requestCondition.getRequestKey())) {
                    isDate = true;
                }
//                logger.debug("getCommonOperator RequestKey: {}",requestCondition.getRequestKey());
                String extendCloumnName = ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey());
                if (StringUtils.isNotBlank(extendCloumnName)) {
                    sql.append(extendCloumnName);
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + "  在项目自定义属性找不到对应的列名！");
                }
            } else {
                if (DatabaseTypeUtils.isDateOfCommonCloumnType(requestCondition.getRequestKey())) {
                    isDate = true;
                }

                if (isTask) {
                    sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                } else {
                    sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                }
            }
            sql.append(" ");
            sql.append(Operator);
            sql.append(" ");
            // 让参数值和value值对应
            String key = requestCondition.getRequestKey() + "_" + requestCondition.getRequestJudge();
            requestCondition.setRequestKey(key);
            if (isDate) {
                String columnName = "#{" + key + "}";
                sql.append(DatabaseTypeUtils.toDateCloumnType(databaseType, columnName));
            } else {
                sql.append("#{");
                sql.append(requestCondition.getRequestKey());
                sql.append("}");
            }
            return sql.toString();
        } else {
            throw new NullPointerException("RequestKey of RequestCondition is null!");
        }
    }

    private static String getCommonOrLike(RequestCondition requestCondition, boolean isExtend, boolean isTask, String whereBaseSql) {
        if (StringUtils.isNotBlank(whereBaseSql)) {
            return getCommonLike(requestCondition, isExtend, isTask, null) + whereBaseSql;
        }
        return getCommonLike(requestCondition, isExtend, isTask, null);
    }

    private static String getCommonLike(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        return getCommonLike(requestCondition, isExtend, isTask, "and");
    }

    private static String getCommonLike(RequestCondition requestCondition, boolean isExtend, boolean isTask, String link) {
        try {
            if (requestCondition.getRequestValue() instanceof String) {
                StringBuilder sql = null;
                if (StringUtils.isEmpty(link)) {
                    sql = new StringBuilder();
                } else {
                    sql = new StringBuilder(" ").append(link).append(" ");
                }
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else {
                    if (isTask) {
                        sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                    } else {
                        sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                    }
                }
                sql.append(" like ");
                sql.append("'%");
                sql.append(requestCondition.getRequestValue());
                sql.append("%'");

                logger.debug("CommonLike sql==== {}", sql.toString());
                return sql.toString();
            } else {
                throw new Exception("CommonLike RequestValue is not String");
            }
        } catch (Exception e) {
            logger.debug("CommonLike RequestValue is not String", e.getMessage());
        }
        return "";
    }

    private static String getCommonOrIn(RequestCondition requestCondition, boolean isExtend, boolean isTask, String whereBaseSql) {
        if (StringUtils.isNotBlank(whereBaseSql)) {
            return getCommonIn(requestCondition, isExtend, isTask, null) + whereBaseSql;
        }
        return getCommonIn(requestCondition, isExtend, isTask, null);
    }

    private static String getCommonIn(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        return getCommonIn(requestCondition, isExtend, isTask, "and");
    }


    private static String getCommonIn(RequestCondition requestCondition, boolean isExtend, boolean isTask, String link) {
        try {
            if (null != requestCondition.getRequestValue() && requestCondition.getRequestValue() instanceof List) {
                StringBuilder sql = null;
                if (StringUtils.isEmpty(link)) {
                    sql = new StringBuilder();
                } else {
                    sql = new StringBuilder(" ").append(link).append(" ");
                }
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else {
                    if (isTask) {
                        sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                    } else {
                        sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                    }
                }
                sql.append(" in (");
                Set<String> inList = new HashSet<String>((List) requestCondition.getRequestValue());
                String instr = org.springframework.util.StringUtils.collectionToDelimitedString(inList, ",", "'", "'");
                sql.append(instr);
                sql.append(" )");
                return sql.toString();
            } else {
                throw new Exception(requestCondition.getRequestKey() + "in 范围的属性值不为 List类");
            }
        } catch (Exception e) {
            logger.debug("getCommonIn 范围的属性值 : {}", e.getMessage());

        }
        return "";
    }

    private static String getCommonNotIn(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        return getCommonNotIn(requestCondition, isExtend, isTask, "and");
    }

    private static String getCommonNotIn(RequestCondition requestCondition, boolean isExtend, boolean isTask, String link) {
        try {
            if (null != requestCondition.getRequestValue() && requestCondition.getRequestValue() instanceof List) {
                StringBuilder sql = null;
                if (StringUtils.isEmpty(link)) {
                    sql = new StringBuilder();
                } else {
                    sql = new StringBuilder(" ").append(link).append(" ");
                }
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else {
                    if (isTask) {
                        sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                    } else {
                        sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                    }
                }
                sql.append(" not in (");
                Set<String> inList = new HashSet<String>((List) requestCondition.getRequestValue());
                String instr = org.springframework.util.StringUtils.collectionToDelimitedString(inList, ",", "'", "'");
                sql.append(instr);
                sql.append(" )");
                return sql.toString();
            } else {
                throw new Exception(requestCondition.getRequestKey() + "in 范围的属性值不为 List类");
            }
        } catch (Exception e) {
            logger.debug("getCommonIn 范围的属性值 : {}", e.getMessage());

        }
        return "";
    }


    private static String getCommonOrder(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        try {
            if (null != requestCondition.getRequestValue()) {
                StringBuilder sql = new StringBuilder();
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else {
                    if (isTask) {
                        sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                    } else {
                        sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                    }
                }
                sql.append(" ");
                sql.append(requestCondition.getRequestValue());

                return sql.toString();
            } else {
                throw new Exception(requestCondition.getRequestKey() + " Order 属性值不为 null");
            }
        } catch (Exception e) {
            logger.debug("getCommonOrder 异常 : {}", e.getMessage());

        }
        return "";
    }

    public static String getCustomCloumnSql() {
        Map<String, String> configMap = ProjectExtendConfigUtils.ProjectExtendConfigMap;
        if (configMap.size() > 0) {
            StringBuilder customSql = new StringBuilder();

            configMap.keySet().forEach(key -> {
                customSql.append(", ");
                customSql.append("ACT_ST_PRO_REL.");
                customSql.append(configMap.get(key));
                customSql.append(" \"");
                customSql.append(key);
                customSql.append("\" ");
            });

            return customSql.toString();
        }
        return "";
    }

    /**
     * 特殊查询的通用方法
     *
     * @param requestCondition
     * @return
     */
    private static String getCommonSpecialSql(RequestCondition requestCondition) {
        if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
            StringBuilder sql = new StringBuilder();
            if (requestCondition.getRequestKey().equals(ProcQuerykey.TASK_ASSIGIN.getValue())) {
                sql.append("  AND ahpi.PROC_INST_ID_ in ( ");
                sql.append("SELECT DISTINCT PROC_INST_ID_ FROM ACT_HI_TASKINST WHERE ASSIGNEE_ = #{taskAssigin}");
                sql.append("   )");
            } else if (requestCondition.getRequestKey().equals(TaskQueryKey.TASK_STATUS.value())) {
                String type = requestCondition.getRequestValue().toString();
                if (StringUtils.isNotBlank(type)) {
                    if (type.equals(TaskStatusQueryEqEnum.NORMAL.getValue())) {
                        sql.append(" AND ACT_ST_TASK.TASK_STATUS=1 ");
                        sql.append(" AND ACT_ST_TASK.TASK_TIMEOUT_STATUS=0 ");
                        sql.append(" AND ACT_ST_TASK.BACK_STATUS is NULL ");
                    } else if (type.equals(TaskStatusQueryEqEnum.BACK.getValue())) {
                        sql.append(" AND ACT_ST_TASK.BACK_STATUS=1 ");
                    } else if (type.equals(TaskStatusQueryEqEnum.BACKED.getValue())) {
                        sql.append(" AND ACT_ST_TASK.BACK_STATUS=2 ");
                    } else if (type.equals(TaskStatusQueryEqEnum.HANG.getValue())) {
                        sql.append(" AND ACT_ST_TASK.TASK_STATUS=2 ");
                    } else if (type.equals(TaskStatusQueryEqEnum.TIMEOUT.getValue())) {
                        sql.append(" AND ACT_ST_TASK.TASK_TIMEOUT_STATUS=1 ");
                    }
                } else {
                    throw new NullPointerException("任务状态特殊查询的状态类型不可以为空！");
                }
            } else if (StringUtils.equals(ProcQuerykey.PROC_All_STATUS.getValue(), requestCondition.getRequestKey())) {
                if (requestCondition.getRequestValue() instanceof List) {
                    List<String> statusList = (List) requestCondition.getRequestValue();
                    if (CollectionUtils.isNotEmpty(statusList)) {
                        List procStatusList = new ArrayList<>();
                        List priorityList = new ArrayList<>();
                        if (statusList.contains(ProcStatusQueryEqEnum.RUNNING.getValue())) {
                            procStatusList.add(1);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.END.getValue())) {
                            procStatusList.add(2);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.SUSPEND.getValue())) {
                            procStatusList.add(3);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.ABANDON.getValue())) {
                            procStatusList.add(4);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.ORDINARY.getValue())) {
                            priorityList.add(100);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.URGENT.getValue())) {
                            priorityList.add(150);
                        } else if (statusList.contains(ProcStatusQueryEqEnum.EXTRA_URGENT.getValue())) {
                            priorityList.add(200);
                        }
                        if (CollectionUtils.isNotEmpty(procStatusList)) {
                            sql.append(" AND ACT_ST_PROC.PROC_STATUS ");
                            sql.append(" in (");
                            Set<String> inList = new HashSet<String>(procStatusList);
                            String instr = org.springframework.util.StringUtils.collectionToDelimitedString(inList, ",", "'", "'");
                            sql.append(instr);
                            sql.append(" )");
                        }
                        if (CollectionUtils.isNotEmpty(priorityList)) {
                            sql.append(" AND ACT_ST_PROC.PRIORITY ");
                            sql.append(" in (");
                            Set<String> inList = new HashSet<String>(priorityList);
                            String instr = org.springframework.util.StringUtils.collectionToDelimitedString(inList, ",", "'", "'");
                            sql.append(instr);
                            sql.append(" )");
                        }
                    }
                } else {
                    throw new NullPointerException("流程状态的属性value 不是List类型！");
                }

            }
            return sql.toString();
        }
        return "";
    }


    /**
     * 处理完成任务的sql
     *
     * @param requestConditions
     * @param params
     * @param databaseType
     */
    public static void handleCompleteTaskRequest(List<RequestCondition> requestConditions, Map<String, Object> params,
                                                 String databaseType, String whereBaseSql) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            Map<String, String> sqlWhereMap = new HashMap<>();
            Map<String, Set<String>> sqlWhereOrMap = new HashMap<>();
            for (RequestCondition requestCondition : requestConditions
            ) {
                checkRequestCondition(requestCondition);
                String requestKey = requestCondition.getRequestKey();
                //判断是否为常用字段 （QueryKey中包含)
                boolean isExtend = true;
                if (RequestKeyUtils.isTaskContains(requestCondition.getRequestKey())) {
                    isExtend = false;
                } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(requestCondition.getRequestKey())) {
                    isExtend = true;
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " 在TaskQueryKey 和 扩展属性中都找不到,请检查key!");
                }
                String oldwhereSql = sqlWhereMap.get(RequestKeyUtils.getTaskName(requestCondition.getRequestKey()));
                oldwhereSql = StringUtils.isNotBlank(oldwhereSql) ? oldwhereSql : "";
                String whereSql = getCommomTableWhereSql(requestCondition, params, isExtend, true, databaseType);
                sqlWhereMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereSql + whereSql);
                //排序条件只可以为一个，多个排序条件
                if (!params.containsKey(RequestKeyUtils.COMPLETE_TASK_ORDER_SQL)) {
                    params.put(RequestKeyUtils.COMPLETE_TASK_ORDER_SQL, getCommomTasktableOrderSql(requestCondition));
                }

                //or where 的条件
                String tableName = RequestKeyUtils.getTaskName(requestCondition.getRequestKey());
                Set<String> oldwhereOrSql = sqlWhereOrMap.get(tableName);
                if (CollectionUtils.isEmpty(oldwhereOrSql)) {
                    oldwhereOrSql = new HashSet<>();
                }
                if (StringUtils.equals(tableName, RequestKeyUtils.TASK_TABLE_NAME)) {
                    oldwhereOrSql.add(getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, whereBaseSql));
                } else {
                    oldwhereOrSql.add(getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, null));
                }
                sqlWhereOrMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereOrSql);
            }
            if (params.get(RequestKeyUtils.COMPLETE_TASK_ORDER_SQL) != null
                    && StringUtils.isBlank(params.get(RequestKeyUtils.COMPLETE_TASK_ORDER_SQL).toString())) {
                params.remove(RequestKeyUtils.COMPLETE_TASK_ORDER_SQL);
            }
            params.put(RequestKeyUtils.DYNAMIC_CLOUMN_TABLE_NAME, getCustomCloumnSql());

            for (String key : sqlWhereOrMap.keySet()
            ) {
                Set<String> whereOrSql = sqlWhereOrMap.get(key);
                String sqlStr = org.springframework.util.StringUtils.collectionToDelimitedString(whereOrSql, " or ");
                if (StringUtils.isNotBlank(sqlStr)) {
                    sqlStr = " and ( " + sqlStr + " )";
                    String sql = sqlWhereMap.get(key);
                    if (StringUtils.isNotBlank(sql)) {
                        sqlWhereMap.put(key, sql + sqlStr);
                    } else {
                        sqlWhereMap.put(key, sqlStr);
                    }
                }
            }
            params.putAll(sqlWhereMap);
        } else {
            params.put(RequestKeyUtils.DYNAMIC_CLOUMN_TABLE_NAME, getCustomCloumnSql());
        }
    }


    /**
     * 处理项目的sql
     *
     * @param requestConditions
     * @param params
     * @param databaseType
     */
    public static void handleProcRequest(List<RequestCondition> requestConditions, Map<String, Object> params,
                                         String databaseType) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            Map<String, String> sqlWhereMap = new HashMap<>();
            Map<String, Set<String>> sqlWhereOrMap = new HashMap<>();
            for (RequestCondition requestCondition : requestConditions
            ) {
                checkRequestCondition(requestCondition);
                String requestKey = requestCondition.getRequestKey();
                //判断是否为常用字段 （QueryKey中包含)
                boolean isExtend = true;
                if (RequestKeyUtils.isProcContains(requestCondition.getRequestKey())) {
                    isExtend = false;
                } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(requestCondition.getRequestKey())) {
                    isExtend = true;
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " 在ProcQuerykey 和 扩展属性中都找不到,请检查key!");
                }
                String oldwhereSql = sqlWhereMap.get(RequestKeyUtils.getProcName(requestCondition.getRequestKey()));
                oldwhereSql = StringUtils.isNotBlank(oldwhereSql) ? oldwhereSql : "";
                String whereSql = getCommomTableWhereSql(requestCondition, params, isExtend, false, databaseType);
                sqlWhereMap.put(RequestKeyUtils.getProcName(requestKey), oldwhereSql + whereSql);
                //排序条件只可以为一个，多个排序条件
                if (!params.containsKey(RequestKeyUtils.PROCESS_ORDER_SQL)) {
                    params.put(RequestKeyUtils.PROCESS_ORDER_SQL, getCommomProctableOrderSql(requestCondition));
                }

                //or where 的条件
                String tableName = RequestKeyUtils.getTaskName(requestCondition.getRequestKey());
                Set<String> oldwhereOrSql = sqlWhereOrMap.get(tableName);
                if (CollectionUtils.isEmpty(oldwhereOrSql)) {
                    oldwhereOrSql = new HashSet<>();
                }
                oldwhereOrSql.add(getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, null));
                sqlWhereOrMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereOrSql);
            }
            params.put(RequestKeyUtils.DYNAMIC_CLOUMN_TABLE_NAME, getCustomCloumnSql());
            for (String key : sqlWhereOrMap.keySet()
            ) {
                Set<String> whereOrSqlSet = sqlWhereOrMap.get(key);
                String sqlStr = org.springframework.util.StringUtils.collectionToDelimitedString(whereOrSqlSet, " or ");
                if (StringUtils.isNotBlank(sqlStr)) {
                    sqlStr = " and ( " + sqlStr + " )";
                    String sql = sqlWhereMap.get(key);
                    if (StringUtils.isNotBlank(sql)) {
                        sqlWhereMap.put(key, sql + sqlStr);
                    } else {
                        sqlWhereMap.put(key, sqlStr);
                    }
                }
            }
            params.putAll(sqlWhereMap);

            //如果查询条件有条件、且没有排序条件 将排序放在最外层
            //排序请求数目
            Long sortCount = requestConditions.stream().filter(requestCondition ->
                    StringUtils.equalsIgnoreCase(requestCondition.getRequestJudge(), QueryJudge.ORDER.value())).count();
            //其他请求数目
            Long otherCount = requestConditions.stream().filter(requestCondition ->
                    !StringUtils.equalsIgnoreCase(requestCondition.getRequestJudge(), QueryJudge.ORDER.value())).count();

            logger.info("查询条件 sortCount :{} otherCount:{}",sortCount,otherCount);
            if (otherCount > 0 && sortCount == 0) {
                params.put(RequestKeyUtils.PROCESS_ORDER_SQL, PROCESS_DEFLAT_ORDER_SQL);
            }
        } else {
            params.put(RequestKeyUtils.DYNAMIC_CLOUMN_TABLE_NAME, getCustomCloumnSql());
        }
    }

    /**
     * 通用条件处理
     *
     * @param requestCondition
     * @param params
     * @param isExtend
     * @param isTask
     * @param databaseType
     * @return and 的 sql
     */
    private static String getCommomTableWhereSql(RequestCondition requestCondition, Map<String, Object> params
            , boolean isExtend, boolean isTask, String databaseType) {
        StringBuilder whereSql = new StringBuilder();
        if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
            if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                whereSql.append(getCommonOperator(requestCondition, "=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                whereSql.append(getCommonOperator(requestCondition, "!=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                whereSql.append(getCommonOperator(requestCondition, ">", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                whereSql.append(getCommonOperator(requestCondition, ">=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                whereSql.append(getCommonOperator(requestCondition, "<", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                whereSql.append(getCommonOperator(requestCondition, "<=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                whereSql.append(getCommonLike(requestCondition, isExtend, isTask));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                whereSql.append(getCommonIn(requestCondition, isExtend, isTask));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_IN.value())) {
                whereSql.append(getCommonNotIn(requestCondition, isExtend, isTask));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                whereSql.append(getCommonSpecialSql(requestCondition));
            }

            if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) &&
                    !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
            }
        }
        return whereSql.toString();
    }


    /**
     * 处理or 条件的sql查询
     *
     * @param requestCondition
     * @param params
     * @param isExtend
     * @param isTask
     * @param databaseType
     * @param whereBaseSql
     * @return
     */
    private static String getCommomTableWhereOrSql(RequestCondition requestCondition, Map<String, Object> params
            , boolean isExtend, boolean isTask, String databaseType, String whereBaseSql) {
        StringBuilder whereOrSql = new StringBuilder();
        if (StringUtils.isNotBlank(requestCondition.getRequestKey())) {
            if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                whereOrSql.append(getCommonOrOperator(requestCondition, "=", isExtend, false, databaseType, whereBaseSql));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                whereOrSql.append(getCommonOrLike(requestCondition, isExtend, false, whereBaseSql));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                whereOrSql.append(getCommonOrIn(requestCondition, isExtend, false, whereBaseSql));
            }
        }
        return whereOrSql.toString();
    }


    private static String getCommomTasktableOrderSql(RequestCondition requestCondition) {
        String orderSql = null;
        if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
            if (TaskQueryKey.START_TIME_TODO.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by  task.CREATE_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (TaskQueryKey.START_TIME_COMPLTETE.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by task.START_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (TaskQueryKey.END_TIME.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by task.END_TIME_ " + requestCondition.getRequestValue().toString();
            } else {
                throw new NullPointerException("任务排序key 限制为 开始时间和结束时间！");
            }
        }
        return orderSql;
    }

    private static String getCommomProctableOrderSql(RequestCondition requestCondition) {
        String orderSql = null;
        if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
            if (ProcQuerykey.STARTTIME.getValue().equals(requestCondition.getRequestKey())) {
                orderSql = " order by hpi.CREATE_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (ProcQuerykey.ENDTIME.getValue().equals(requestCondition.getRequestKey())) {
                orderSql = " order by hpi.START_TIME_ " + requestCondition.getRequestValue().toString();
            } else {
                throw new NullPointerException("任务排序key 限制为 开始时间和结束时间！");
            }
        }
        return orderSql;
    }

    private static void checkRequestCondition(RequestCondition requestCondition) {
        if (requestCondition == null) {
            throw new NullPointerException("requestCondition is null !");
        } else if (requestCondition != null && StringUtils.isBlank(requestCondition.getRequestKey())) {
            throw new NullPointerException("RequestKey is null !");
        } else if (requestCondition != null && StringUtils.isBlank(requestCondition.getRequestJudge())) {
            throw new NullPointerException("RequestJudge is null !");
        } else if (requestCondition != null && requestCondition.getRequestValue() == null) {
            throw new NullPointerException("RequestValue is null !");
        }
    }

    private static String getCommonLikes(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        try {

            String requestKey = requestCondition.getRequestKey();
            Object values = requestCondition.getRequestValue();

            if (null != values && values instanceof List) {
                StringBuilder sql = new StringBuilder(" and ( ");
                List list = (List) values;

                for (int i = 0; i < list.size(); i++) {
                    if (isExtend) {
                        sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestKey));
                    } else {
                        if (isTask) {
                            sql.append(RequestKeyUtils.getTaskcolumn(requestKey));
                        } else {
                            sql.append(RequestKeyUtils.getProccolumn(requestKey));
                        }
                    }
                    sql.append(" like ");
                    sql.append("'");
                    sql.append(list.get(i));
                    sql.append("'");
                    if (i != list.size() - 1) {
                        sql.append(" or ");
                    }
                }


                sql.append(" ) ");

                return sql.toString();
            } else {
                throw new Exception(requestCondition.getRequestKey() + "likes 范围的属性值不为 List类");
            }
        } catch (Exception e) {
            logger.debug("getCommonLikes 范围的属性值 : {}", e.getMessage());

        }
        return "";
    }


}
