package cn.gtmap.gtc.workflow.enums.statistics;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/10/9
 * @description
 */
public enum StatisticsType {

    REC_STATISTIC("REC_STATISTIC", "收件量统计"),
    RUN_STATISTIC("RUN_STATISTIC", "正在办理量统计"),
    END_STATISTIC("END_STATISTIC","办结量统计");

    private String name;
    private String remark;

    StatisticsType(String name, String remark) {
        this.name = name;
        this.remark = remark;
    }

    public String getName() {
        return name;
    }

    public String getRemark() {
        return remark;
    }

    public static StatisticsType enumValue(String name){
        StatisticsType[] types = StatisticsType.values();
        for (int i = 0; i < types.length; i++){
            if (types[i].getName().equals(name)){
                return types[i];
            }
        }
        return null;
    }
}


