package cn.gtmap.gtc.workflow.entity;

import cn.gtmap.gtc.workflow.Constant;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import cn.gtmap.gtc.workflow.utils.BeanUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.util.StringUtils;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author zk
 */
@Table(name = "ACT_ST_TASK")
public class StatisticsTask implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 任务id
     */
    @Id
    private String taskId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 流程定义id
     */
    private String procDefId;

    /**
     * 流程定义KEY
     */
    private String procDefKey;

    /**
     * 流程实例id
     */
    private String procInsId;

    /**
     * 任务发起人部门id
     */
    private String taskAssDepId;

    /**
     * 任务发起人角色id
     */
    private String taskAssRoleId;

    /**
     * 任务发起人id
     */
    private String taskAssId;

    /**
     * 任务开始时间
     */
    private Date taskStartDate;

    /**
     * 任务到期天数
     */
    private Integer taskDueDays;

    /**
     * 任务到期小时数
     */
    private Integer taskDueHours;

    /**
     * 任务实际到期时间
     */
    private Date taskDueDate;

    /**
     * 任务结束时间
     */
    private Date taskEndDate;

    /**
     * 任务超期天数
     */
    private Integer taskTimeoutDays;

    /**
     * 任务超期时数
     */
    private Integer taskTimeoutHours;

    /**
     * 任务状态（1在线，2结束）
     */
    private Integer taskStatus;

    /**
     * 认领状态 （0：指派，1：未认领，2：已认领）
     */
    private Integer claimStatus;

    /**
     * 流程创建人
     */
    private String procStartUserName;

    /**
     * 任务发起人name
     */
    private String taskAssName;

    /**
     * 任务超期状态
     */
    private Integer taskTimeoutStatus;

    /**
     * 业务类型
     */
    private String category;

    /**
     * 1：退回任务 2：被退回任务
     */
    private Integer backStatus;

    /*
     *  最后一次计算时间
     * */
    private Date reckonTime;

    /*
    *  统计时间 （分钟）
    * */
    private Long statisticsTime;

    /*
    *  工作日ID
    * */
    private String workId;

    /**
     * 任务锁定时间合并（分钟）
     */
    private Long sumLockTime;

    /**
     * 任务认领时间合并（分钟）
     */
    private Long sumClaimTime;

    /**
     * 全部统计时间，除掉非工作日（分钟）
     */
    private Long fullStatisticsTime;

    /**
     * 加急原因
     */
    private String taskUrgentReason;

    /**
     * 工作日办理状态
     * 0 非工作日或非工作时间办理 , 1 工作日时间办理
     */
    private Integer workDayTransactStatus;


    public StatisticsTask() {
    }

    public StatisticsTask(StatisticsTaskDto statisticsTaskDto) {
        BeanUtil.copyBean(statisticsTaskDto, this);
    }

    public Long getTaskStartDateInLong() {
        return taskStartDate == null ? null : taskStartDate.getTime() - Constant.B_UTC;
    }

    public Long getTaskEndDateInLong() {
        return taskEndDate == null ? null : taskEndDate.getTime() - Constant.B_UTC;
    }

    public List<String> getTaskAssDepIdList() {
        List<String> list;
        if (StringUtils.isEmpty(taskAssDepId)) {
            list = new ArrayList<>();
            list.add("");
        } else {
            list = Arrays.asList(taskAssDepId.split(Constant.EN_COMMA));
        }
        return list;
    }


    public Integer getWorkDayTransactStatus() {
        return workDayTransactStatus;
    }

    public void setWorkDayTransactStatus(Integer workDayTransactStatus) {
        this.workDayTransactStatus = workDayTransactStatus;
    }

    @JsonIgnore
    public StatisticsTaskDto getBean() {
        StatisticsTaskDto statisticsTask = new StatisticsTaskDto();
        BeanUtil.copyBean(this, statisticsTask);
        return statisticsTask;
    }

    public StatisticsTask copy() {
        StatisticsTask statisticsTask = new StatisticsTask();
        BeanUtil.copyBean(this, statisticsTask);
        return statisticsTask;
    }

    @Override
    public String toString() {
        return "StatisticsTask{" +
                "taskId='" + taskId + '\'' +
                ", taskName='" + taskName + '\'' +
                ", procDefId='" + procDefId + '\'' +
                ", procInsId='" + procInsId + '\'' +
                ", taskAssDepId='" + taskAssDepId + '\'' +
                ", taskAssRoleId='" + taskAssRoleId + '\'' +
                ", taskAssId='" + taskAssId + '\'' +
                ", taskStartDate=" + taskStartDate +
                ", taskDueDays=" + taskDueDays +
                ", taskDueHours=" + taskDueHours +
                ", taskDueDate=" + taskDueDate +
                ", taskEndDate=" + taskEndDate +
                ", taskTimeoutDays=" + taskTimeoutDays +
                ", taskTimeoutHours=" + taskTimeoutHours +
                ", taskStatus=" + taskStatus +
                ", claimStatus=" + claimStatus +
                ", procStartUserName='" + procStartUserName + '\'' +
                ", taskAssName='" + taskAssName + '\'' +
                ", category='" + category + '\'' +
                ", taskTimeoutStatus=" + taskTimeoutStatus +
                '}';
    }

    public Long  getStatisticsTime() {
        if (statisticsTime == null){
            return 0l;
        }
        return statisticsTime;
    }

    public void setStatisticsTime(Long statisticsTime) {
        this.statisticsTime = statisticsTime;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId == null ? null : taskId.trim();
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId == null ? null : procDefId.trim();
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcInsId() {
        return procInsId;
    }

    public void setProcInsId(String procInsId) {
        this.procInsId = procInsId == null ? null : procInsId.trim();
    }

    public String getTaskAssDepId() {
        return taskAssDepId;
    }

    public void setTaskAssDepId(String taskAssDepId) {
        this.taskAssDepId = taskAssDepId == null ? null : taskAssDepId.trim();
    }

    public String getTaskAssRoleId() {
        return taskAssRoleId;
    }

    public void setTaskAssRoleId(String taskAssRoleId) {
        this.taskAssRoleId = taskAssRoleId == null ? null : taskAssRoleId.trim();
    }

    public String getTaskAssId() {
        return taskAssId;
    }

    public void setTaskAssId(String taskAssId) {
        this.taskAssId = taskAssId == null ? null : taskAssId.trim();
    }

    public Date getTaskStartDate() {
        return taskStartDate;
    }

    public void setTaskStartDate(Date taskStartDate) {
        this.taskStartDate = taskStartDate;
    }

    public Integer getTaskDueDays() {
        return taskDueDays;
    }

    public void setTaskDueDays(Integer taskDueDays) {
        this.taskDueDays = taskDueDays;
    }

    public Integer getTaskDueHours() {
        return taskDueHours;
    }

    public void setTaskDueHours(Integer taskDueHours) {
        this.taskDueHours = taskDueHours;
    }

    public Date getTaskDueDate() {
        return taskDueDate;
    }

    public void setTaskDueDate(Date taskDueDate) {
        this.taskDueDate = taskDueDate;
    }

    public Date getTaskEndDate() {
        return taskEndDate;
    }

    public void setTaskEndDate(Date taskEndDate) {
        this.taskEndDate = taskEndDate;
    }

    public Integer getTaskTimeoutDays() {
        return taskTimeoutDays;
    }

    public void setTaskTimeoutDays(Integer taskTimeoutDays) {
        this.taskTimeoutDays = taskTimeoutDays;
    }

    public Integer getTaskTimeoutHours() {
        return taskTimeoutHours;
    }

    public void setTaskTimeoutHours(Integer taskTimeoutHours) {
        this.taskTimeoutHours = taskTimeoutHours;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Integer getClaimStatus() {
        return claimStatus;
    }

    public void setClaimStatus(Integer claimStatus) {
        this.claimStatus = claimStatus;
    }

    public String getTaskAssName() {
        return taskAssName;
    }

    public void setTaskAssName(String taskAssName) {
        this.taskAssName = taskAssName;
    }

    public String getProcStartUserName() {
        return procStartUserName;
    }

    public void setProcStartUserName(String procStartUserName) {
        this.procStartUserName = procStartUserName;
    }

    public Integer getTaskTimeoutStatus() {
        return taskTimeoutStatus;
    }

    public void setTaskTimeoutStatus(Integer taskTimeoutStatus) {
        this.taskTimeoutStatus = taskTimeoutStatus;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(Integer backStatus) {
        this.backStatus = backStatus;
    }

    public Date getReckonTime() {
        return reckonTime;
    }

    public void setReckonTime(Date reckonTime) {
        this.reckonTime = reckonTime;
    }

    public String getWorkId() {
        return workId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }

    public Long getSumLockTime() {
        return sumLockTime;
    }

    public void setSumLockTime(Long sumLockTime) {
        this.sumLockTime = sumLockTime;
    }

    public Long getSumClaimTime() {
        return sumClaimTime;
    }

    public void setSumClaimTime(Long sumClaimTime) {
        this.sumClaimTime = sumClaimTime;
    }

    public Long getFullStatisticsTime() {
        return fullStatisticsTime;
    }

    public void setFullStatisticsTime(Long fullStatisticsTime) {
        this.fullStatisticsTime = fullStatisticsTime;
    }

    public String getTaskUrgentReason() {
        return taskUrgentReason;
    }

    public void setTaskUrgentReason(String taskUrgentReason) {
        this.taskUrgentReason = taskUrgentReason;
    }
}
