package cn.gtmap.gtc.workflow.clients.statistics;

import cn.gtmap.gtc.workflow.domain.statistics.DepartmentalProcStatistics;
import cn.gtmap.gtc.workflow.domain.statistics.NormalProcStatistics;
import cn.gtmap.gtc.workflow.domain.statistics.PersonalProcStatistics;
import cn.gtmap.gtc.workflow.vo.FastHandleTaskQueryCondition;
import cn.gtmap.gtc.workflow.vo.NonWorkDayQueryCondition;
import cn.gtmap.gtc.workflow.vo.StatisticsTaskQueryCondition;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author Fjj
 * @date 2018/7/25
 */
@FeignClient("${app.services.bpm-statistics:bpm-statistics}")
@RequestMapping("/rest/proc-statistics/v1")
public interface ProcStatisticsClient {

    /**
     * 获取一般性统计结果(可获取到各类型流程的流程数、未办结数、超期数量、超期天数)
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping(value = "/normal")
    List<NormalProcStatistics> getNormalStatisticsList(@RequestParam(value = "startDate", required = false) String startDate,
                                                       @RequestParam(value = "endDate", required = false) String endDate);

    /**
     * 获取个人的统计结果(可获取到各类型流程的流程数、待办数、超期数量、超期天数)
     *
     * @param userId
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping(value = "/users/{userId}")
    List<PersonalProcStatistics> getPersonalStatisticsList(@PathVariable("userId") String userId,
                                                           @RequestParam(value = "startDate", required = false) String startDate,
                                                           @RequestParam(value = "endDate", required = false) String endDate);

    /**
     * 根据部门id获取统计合计信息
     *
     * @param departmentIds
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping(value = "/departments")
    List<DepartmentalProcStatistics> getDepartmentalStatisticsList(@RequestParam(value = "departmentIds") String departmentIds, @RequestParam(value = "startDate", required = false) String startDate,
                                                                   @RequestParam(value = "endDate", required = false) String endDate);


    /**
     * 超快办件统计
     * @param fastHandleQueryCondition 查询条件
     * @param pageSize 分页数据 size
     * @param pageNumber 分页数据 number
     * @return
     */
    @PostMapping(value = "/process/fastHandle/statistic")
    Page<Map<String, Object>> pageFastHandleProc(@RequestBody FastHandleTaskQueryCondition fastHandleQueryCondition,
                                                      @RequestParam("pageSize") Integer pageSize,
                                                      @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 超期办件
     * @param statisticsTaskQueryCondition 查询条件
     * @param pageSize 分页数据 size
     * @param pageNumber 分页数据 number
     * @return
     */
    @PostMapping(value = "/task/overdue/statistic")
    Page<Map<String, Object>> pageOverdueTask(@RequestBody StatisticsTaskQueryCondition statisticsTaskQueryCondition,
                                                   @RequestParam("pageSize") Integer pageSize,
                                                   @RequestParam("pageNumber") Integer pageNumber);


    /**
     * 非工作日办件
     * @param nonWorkDayQueryCondition 查询条件
     * @param pageSize 分页数据 size
     * @param pageNumber 分页数据 number
     * @return
     */
    @PostMapping(value = "/task/NonWorkDay/statistic")
    Page<Map<String, Object>> pageNonWorkDayHandleTask(@RequestBody NonWorkDayQueryCondition nonWorkDayQueryCondition,
                                                            @RequestParam("pageSize") Integer pageSize,
                                                            @RequestParam("pageNumber") Integer pageNumber);

}
