package cn.gtmap.gtc.workflow.clients.manage;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/9/11
 * @description 流程测试类
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/test")
public interface TestClient {

    @RequestMapping(value = "/time-out",method = RequestMethod.GET)
    public boolean timeOut(@RequestParam("count") int count);

    @RequestMapping(value = "/http-forward",method = RequestMethod.GET)
    public String httpForward();

    @RequestMapping(value = "/http-back",method = RequestMethod.GET)
    public String httpBack();

}
