package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.MessagesNumDto;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import cn.gtmap.gtc.workflow.vo.StatisticsTaskVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by hhuu on 2019/1/28.
 */
@FeignClient(name = "${app.services.bpm-manage:bpm-manage}")
@RequestMapping("/manage/v1")
public interface StatisticsTaskClient {

    /**
     * 根据id查询任务记录
     *
     * @param id
     */
    @GetMapping(value = "/statistics-task/tasks/{id}")
    StatisticsTaskDto getById(@PathVariable("id") String id);

    /**
     * 根据用户获取待办和待认领的任务数目
     *
     * @param useName
     * @return
     */
    @GetMapping("/statistics-task/task-message/count}")
    public MessagesNumDto getActiveByUserId(@RequestParam("useName") String useName);

    /**
     * 根据流程实例id 获取统计信息
     * @param procInsId 流程实例id
     * @return 返回数据
     */
    @GetMapping(value = "/statistics-task/{procInsId}")
    public List<StatisticsTaskVo> queryStatisticsTaskInfoByProcessInsId(@PathVariable(value = "procInsId") String procInsId);


}
