package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.ModelStatus;
import cn.gtmap.gtc.workflow.domain.define.ProcessModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhouk
 * @Title: ProcessModelClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/7/1214:24
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface ProcessModelClient {


    @RequestMapping(
            value = {"/process-models"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public Page<ProcessModel> queryProcessModels(@RequestParam(required = false,value = "filter") String filter,
                                                 @RequestParam(required = false,value = "statusKey") String statusKey,
                                                 @RequestParam(required = false,value = "userName") String userName,
                                                 @RequestParam("modelType") Integer modelType, Pageable pageable);

    /**
     *新增流程定义的模版并修改流程定义模版的状态
     */
    @RequestMapping(
            value = {"/process-models"},
            method = {RequestMethod.POST}
    )
    public ProcessModel addModelAndUpdStatus(@RequestParam("userId") String userId,
                                             @RequestBody ProcessModel processModel);

    /**
     * 更新流程模版信息的部分信息
     * @param modelId
     * @param processModel
     * @return
     */
    @RequestMapping(
            value = {"/process-models/{modelId}"},
            method = {RequestMethod.PATCH}
    )
    public ProcessModel updateProcessModel(@PathVariable("modelId") String modelId,
                                           @RequestBody ProcessModel processModel);

    /**
     * 保存流程模型的状态
     * @param modelStatus
     */
    @RequestMapping(
            value = {"/process-models/status"},
            method = {RequestMethod.POST}
    )
    public void saveModelStatus(@RequestBody ModelStatus modelStatus);


    /**
     * 部署流程定义
     * @param modelId
     */
    @RequestMapping(
            value = {"/process-models/{modelId}/deployment"},
            method = {RequestMethod.GET}
    )
    public void deployModel(@PathVariable("modelId") String modelId);
    /**
     * 获取流程模版的详细信息
     * @param modelId
     * @return
     */
    @RequestMapping(
            value = {"/process-models/{modelId}"},
            method = {RequestMethod.GET}
    )
    public ProcessModel getModel(@PathVariable("modelId") String  modelId);


    /**
     * 根据流程定义Key获取流程模型信息
     * @param processDefKey 流程定义Key
     * @return 返回模型信息
     */
    @RequestMapping(
            value = {"/process-models/processDefKey"},
            method = {RequestMethod.GET}
    )
    ProcessModel getModelByProcessDefKey(@RequestParam("processDefKey") String processDefKey);

    /**
     * 删除流程定义模版
     * @param modelId
     */
    @RequestMapping(
            value = {"/process-models/{modelId}"},
            method = {RequestMethod.DELETE}
    )
    public void deleteProcessModel(@PathVariable("modelId")String modelId);


}
