package cn.gtmap.gtc.workflow.domain.statistics;

import java.util.Date;

/**
 * @author xieziwei
 * 用于计算有效工作日时间
 */
public class BetweenWorkDayDto {

    /**
     * 流程实例id
     * (必传)
     */
    private String processInsId;


    /**
     * 工作日计算方式,默认根据流程关联工作日查询
     * 类型:
     *  1 process           #流程关联 默认关联
     *  2 processStartUser  #启动人员关联
     */
    private String calculationType = "process";


    /**
     * 开始时间
     * yyyy-MM-dd HH:mm:ss
     * (必传)
     */
    private String startTime;


    /**
     * 结束时间
     * yyyy-MM-dd HH:mm:ss
     * (必传)
     */
    private String endTime;


    /**
     * 计算类型,小时,天数,可查看WorkUtils.computeMode枚举类
     * (必传)
     */
    private Integer computeMode;


    /**
     * 两个时间直接的工作日时间
     * 根据 computeMode类型计算
     */
    private Integer times;


    /**
     * 是否超期
     * 根据传入时间以及当前流程配置的流程超期配置,判断是否超期
     */
    private boolean overdue;


    /**
     * 超期时间
     * 根据 computeMode类型计算
     * 根据传入时间以及当前流程配置的流程超期配置,获取超期时间
     */
    private Integer overdueTime;


    /**
     * 流程超期时间
     */
    private Date dueTime;


    /**
     * 流程启动人员
     */
    private String processStartUser;


    /**
     * 流程相关办理人员
     */
    private String relatedUser;




    public String getProcessInsId() {
        return processInsId;
    }

    public void setProcessInsId(String processInsId) {
        this.processInsId = processInsId;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(Integer computeMode) {
        this.computeMode = computeMode;
    }

    public String getCalculationType() {
        return calculationType;
    }

    public void setCalculationType(String calculationType) {
        this.calculationType = calculationType;
    }

    public Integer getTimes() {
        return times;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }


    public boolean isOverdue() {
        return overdue;
    }

    public void setOverdue(boolean overdue) {
        this.overdue = overdue;
    }

    public Integer getOverdueTime() {
        return overdueTime;
    }

    public void setOverdueTime(Integer overdueTime) {
        this.overdueTime = overdueTime;
    }

    public Date getDueTime() {
        return dueTime;
    }

    public void setDueTime(Date dueTime) {
        this.dueTime = dueTime;
    }

    public String getProcessStartUser() {
        return processStartUser;
    }

    public void setProcessStartUser(String processStartUser) {
        this.processStartUser = processStartUser;
    }

    public String getRelatedUser() {
        return relatedUser;
    }

    public void setRelatedUser(String relatedUser) {
        this.relatedUser = relatedUser;
    }
}
