package cn.gtmap.gtc.workflow.clients.statistics;

import cn.gtmap.gtc.workflow.domain.statistics.BetweenWorkDayDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author xieziwei
 * 流程超期计算
 */
@FeignClient("${app.services.bpm-statistics:bpm-statistics}")
@RequestMapping("/rest/workday-statistics/v1")
public interface WorkDayUtilClient {


    /**
     * 批量计算流程实例下,开始时间到结束时间,花费工作日,以及超期信息
     * @param betweenWorkDay 流程以及时间相关计算参数
     * @return 超期信息
     * @throws Exception 异常信息处理
     */
    @RequestMapping(value = "/batch/workday-config/compute-workday-days",method = RequestMethod.POST)
    List<BetweenWorkDayDto> batchGetBetweenDays(@RequestBody List<BetweenWorkDayDto> betweenWorkDay) throws Exception;



}
