package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.manage.UserTaskDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author xieziwei
 * @version 2021/9/10
 * @description
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface ProcNodeManageClient {


    /**
     * 根据流程定义查询当前流程所有的节点
     * @param procDefKey 流程定义key
     * @param filter 过滤数据
     * @return
     */
    @GetMapping(value = "user-task-all")
    List<UserTaskDto> getAllUserTask(@RequestParam(value = "procDefKey") String procDefKey, @RequestParam(required = false,value = "filter")String filter);



}
