package cn.gtmap.gtc.workflow.helper;

import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.utils.DateUtils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

/**
 * 工作日计算帮助类
 * <p>
 * 严格按照工作日作息时间计算，精确到分
 *
 * @author Fjj
 * @date 2018/8/9
 */
public class StrictWorkdayHelper extends AbstractWorkdayHelper {


    public StrictWorkdayHelper(List<WorkDay> list) {
        init(list);
    }

    /**
     * 工作日计算，加天数（排除节假日和休息日）,用于计算到期时间
     *
     * @param calendar 起算时间
     * @param day      相加天数，大于0
     * @return Calendar 返回相加day天，并且排除节假日和周末后的日期
     */
    @Override
    public Calendar addDateByWorkDay(Calendar calendar, int day) throws ParseException {
        WorkDayTimeType workDayTimeType = checkWorkTimeType(calendar);
        Calendar dueCalendar = null;
        if (workDayTimeType == WorkDayTimeType.NOT_WORKDAY || workDayTimeType == WorkDayTimeType.BEFORE_MORNING_STRAT
                || workDayTimeType == WorkDayTimeType.AFTER_AFTERNOON_END) {
            //如果当天不是工作日或在早晨工作时间开始前，需要先找到最近的开始工作时间
            Calendar realStartTime = getNearWorkTime(calendar, workDayTimeType);
            String realStartDateStr = dateFormat.format(realStartTime.getTime());
            int indexInWorkDay = indexMap.get(realStartDateStr) + (day - 1);
            WorkDay workDay = workDayList.get(indexInWorkDay);
            dueCalendar = DateUtils.toCalendar(workDay.getWorkDay() + A_BLANK + workDay.getAfternoonTimeEnd(), DateUtils.DateFormatType.DATETIME);
        } else {
            String dateStr = dateFormat.format(calendar.getTime());
            int indexInWorkDay = indexMap.get(dateStr);
            int dueIndexInWorkDay = indexInWorkDay + day;
            WorkDay startWorkDay = workDayList.get(indexInWorkDay);
            WorkDay dueWorkDay = workDayList.get(dueIndexInWorkDay);
            if (workDayTimeType == WorkDayTimeType.LUNCH_BREAK) {
                //午休时间加天后，到期时间为指定天数后的上午结束时间
                dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + dueWorkDay.getMorningTimeEnd(), DateUtils.DateFormatType.DATETIME);
            } else if (workDayTimeType == WorkDayTimeType.MORNING_WORKTIME) {
                //早晨工作时间加天后，依然在早上，超出早上按早晨结束时间算
                int temp = DateUtils.getTimeDifferenceInMinutesByTime(startWorkDay.getMorningTimeStart(), timeFormat.format(calendar.getTime()));
                if (temp >= workMinutesList.get(dueIndexInWorkDay).getMorningMinutes()) {
                    dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + dueWorkDay.getMorningTimeEnd(), DateUtils.DateFormatType.DATETIME);
                } else {
                    dueCalendar = DateUtils.addMinutes(DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + dueWorkDay.getMorningTimeStart(), DateUtils.DateFormatType.DATETIME), temp);
                }
            } else if (workDayTimeType == WorkDayTimeType.AFTERNOON_WORKTIME) {
                //下午工作时间加天后，依然在下午，超出的按下午结束时间算
                int temp = DateUtils.getTimeDifferenceInMinutesByTime(startWorkDay.getAfternoonTimeStart(), timeFormat.format(calendar.getTime()));
                if (temp >= workMinutesList.get(dueIndexInWorkDay).getAfternoonMinutes()) {
                    dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + dueWorkDay.getAfternoonTimeEnd(), DateUtils.DateFormatType.DATETIME);
                } else {
                    dueCalendar = DateUtils.addMinutes(DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + dueWorkDay.getAfternoonTimeStart(), DateUtils.DateFormatType.DATETIME), temp);
                }
            }
        }
        return dueCalendar;
    }


}
