package cn.gtmap.gtc.workflow.enums.task;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/6
 * @description
 */
public enum PriorityStatus {

    NORMAL(50, "普通"),
    ORDINARY(100,"优先"),
    URGENT(150, "紧急"),
    EXTRA_URGENT(200, "特急");

    private Integer value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    PriorityStatus(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public static String getPriorityName(Integer value){
        if (value == null) {
            return "普通";
        }

        switch (value){
            case 50:
                return "普通";
            case 100:
                return "一般";
            case 150:
                return "紧急";
            case 200:
                return "特急";
        }

        return "普通";
    }
}
