package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.common.BaseRestActionRepresentation;
import cn.gtmap.gtc.workflow.domain.common.MultipartDto;
import cn.gtmap.gtc.workflow.domain.common.ResultListData;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelInformationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ReviveModelResultRepresentationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ValidationErrorView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author zhouk
 * @Title: ModelerClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/8/1610:33
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("/define/v1")
public interface ModelerClient {

    /**
     * 模型的下载
     * @param processModelId
     */
    @RequestMapping(
            value = {"/models/{processModelId}/bpmn20"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]>  getProcessModelBpmn20Xml( @PathVariable("processModelId") String processModelId);


    /**
     * 历史的模型的下载
     * @param processModelId
     * @param processModelHistoryId
     */
    @RequestMapping(
            value = {"/models/{processModelId}/history/{processModelHistoryId}/bpmn20"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]> getHistoricProcessModelBpmn20Xml(@PathVariable("processModelId") String processModelId,
                                                                   @PathVariable("processModelHistoryId") String processModelHistoryId);


    /**
     * 模型的基础信息
     * @param modelId
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public ModelRepresentationView getModel(@PathVariable("modelId") String modelId);

    /**
     * 模型的省略图
     * @param modelId
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/thumbnail"},
            method = {RequestMethod.GET},
            produces = {"image/png"}
    )
    public  ResponseEntity<byte[]> getModelThumbnail(@PathVariable("modelId") String modelId);


    /**
     * 模型基础信息的更新
     * @param modelId
     * @param updatedModel
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}"},
            method = {RequestMethod.PUT}
    )
    public ModelRepresentationView updateModel(@PathVariable("modelId") String modelId, @RequestBody ModelRepresentationView updatedModel);


    /**
     * 模型的删除
     * @param modelId
     */
    @ResponseStatus(HttpStatus.OK)
    @RequestMapping(
            value = {"/models/{modelId}"},
            method = {RequestMethod.DELETE}
    )
    public void deleteModel(@PathVariable("modelId") String modelId);

    /**
     * 获取模型的json数据
     * @param modelId
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/json"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public ObjectNode getModelJSON(@PathVariable("modelId") String modelId) ;

    /**
     * 保存模型的json数据
     * @param modelId
     * @param values
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/json"},
            method = {RequestMethod.POST}
    )
    public ModelRepresentationView saveModel(@PathVariable("modelId") String modelId, @RequestBody MultiValueMap<String, String> values, @RequestParam("userId") String userId);


    /**
     *模型上传新的版本
     * @param modelId
     * @param file
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/newversion"},
            method = {RequestMethod.POST}
    )
    public ModelRepresentationView importNewVersion(@PathVariable("modelId") String modelId, @RequestParam("file") MultipartFile file);
    /**
     *模型的历史数据
     * @param modelId
     * @param includeLatestVersion
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/history"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public ResultListData getModelHistoryCollection(@PathVariable("modelId") String modelId,
                                                    @RequestParam(value = "includeLatestVersion",required = false) Boolean includeLatestVersion);

    /**
     *摸个模型的历史版本的基础信息
     * @param modelId
     * @param modelHistoryId
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/history/{modelHistoryId}"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public ModelRepresentationView getProcessModelHistory(@PathVariable("modelId") String modelId,
                                                          @PathVariable("modelHistoryId") String modelHistoryId);

    /**
     *历史的版本的操作(保存，新建，事件)
     * @param modelId
     * @param modelHistoryId
     * @param action
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/history/{modelHistoryId}/{userId}"},
            method = {RequestMethod.POST},
            produces = {"application/json"}
    )
    public ReviveModelResultRepresentationView executeProcessModelHistoryAction(@PathVariable("modelId") String modelId,
                                                                                @PathVariable("modelHistoryId") String modelHistoryId,
                                                                                @PathVariable("userId") String userId,
                                                                                @RequestBody(required = true) BaseRestActionRepresentation action);

    /**
     *查询模版的父辈关联
     * @param modelId
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/parent-relations"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<ModelInformationView> getModelRelations(@PathVariable("modelId") String modelId);

    /**
     *BPMN的文件的上传
     * @param file
     * @return
     */
    @PostMapping(
            value = {"/models/upload"},
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = MediaType.MULTIPART_FORM_DATA_VALUE
    )
    @ResponseBody
    public ModelRepresentationView importProcessModel( @RequestParam("userId")String userId,@RequestPart("file") MultipartFile file);


    /**
     * 按照实体方式上传文件
     * @param multipartDto
     * @return
     */
    @PostMapping("/models/upload/convent")
    @ResponseBody
    public ModelRepresentationView  importProcessModelConvent(@RequestBody MultipartDto multipartDto);

    /**
     *BPMN的文件的上传（IE）
     * @param file
     * @return
     */
    @PostMapping(
            value = {"/models/upload/text"},
            produces = {"application/json"}
    )
    public String importProcessModelText(@RequestParam("userId")String userId,@RequestPart("file") MultipartFile file);

    /**
     *模版的创建
     * @param modelRepresentationView
     * @return
     */
    @RequestMapping(
            value = {"/models"},
            method = {RequestMethod.POST},
            produces = {"application/json"}
    )
    public ModelRepresentationView createModel(@RequestParam("userId")String userId,@RequestBody ModelRepresentationView modelRepresentationView);

    /**
     *模版的验证
     * @param body
     * @return
     */
    @RequestMapping(
            value = {"/models/validate"},
            method = {RequestMethod.POST},
            consumes = {"application/json"}
    )
    public List<ValidationErrorView> validate(@RequestBody JsonNode body);


    /**
     * 流程模版的复制
     * @param modelId
     * @param userId
     * @param modelRepresentationView
     * @return
     */
    @RequestMapping(
            value = {"/models/{modelId}/duplicates"},
            method = {RequestMethod.POST},
            produces = {"application/json"}
    )
    public ModelRepresentationView duplicateModel(@PathVariable("modelId") String modelId,
                                                  @RequestParam("userId") String userId,
                                                  @RequestBody ModelRepresentationView modelRepresentationView);
}
