package cn.gtmap.gtc.workflow.utils;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 描述:
 *
 * @author lenovo
 * @create 2019-03-01 17:31
 */
public class HttpRestUtils {



    public static Object postJsonData(String url, String jsonParam, RestTemplate restTemplate) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.APPLICATION_JSON;
        headers.setContentType(type);
        HttpEntity<String> formEntity = new HttpEntity<String>(jsonParam, headers);
        Object object = restTemplate.postForObject(url, formEntity, Object.class);
        return object;
    }

    public static Object postData(String url, Map<String,Object> paramMap, RestTemplate restTemplate) {
        HttpEntity<MultiValueMap<String, String>> request = null;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.APPLICATION_FORM_URLENCODED;
        headers.setContentType(type);
        if(paramMap!=null){
            MultiValueMap<String, String> map= new LinkedMultiValueMap<String, String>();
            for (String key : paramMap.keySet()) {
                map.add(key,paramMap.get(key)==null?"":paramMap.get(key).toString());
            }
            request = new HttpEntity<MultiValueMap<String, String>>(map, headers);
        }
        Object object = restTemplate.postForEntity( url, request , Object.class );
        return object;
    }
}
