package cn.gtmap.gtc.workflow.enums.task;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/2/20
 * @description
 */
public enum CommentType {

    /*
    *  转发审批意见
    * */
    FORWARD_OPINION("forward_opinion"),
    /*
     *  退回审批意见
     * */
    BACK_OPINION("back_opinion"),

    /*
     *  挂起意见
     * */
    SUSPEND_OPINION("suspend_opinion"),

    /*
     *  解挂意见
     * */
    ACTIVITY_OPINION("activity_opinion");

    private final String value;

    CommentType(String v){
        value = v;
    }

    public String value() {
        return value;
    }


    public static CommentType enumValue(String type){
        if ("forward_opinion".equals(type)) {
            return FORWARD_OPINION;
        }

        if ("back_opinion".equals(type)) {
            return BACK_OPINION;
        }

        if ("suspend_opinion".equals(type)) {
            return SUSPEND_OPINION;
        }

        if ("activity_opinion".equals(type)) {
            return ACTIVITY_OPINION;
        }

        return null;
    }
}
