package cn.gtmap.gtc.workflow.enums.task;

public enum ClaimStatusType {

    APPOINT(0, "指派"),

    UNCLAIMED(1, "未认领"),

    CLAIMED(2, "认领");

    private int value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    ClaimStatusType(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }


    public static String getClaimStatusName(Integer value){
        if (value == null) {
            return "指派";
        }

        switch (value){
            case 0:
                return "指派";
            case 1:
                return "未认领";
            case 2:
                return "认领";
        }

        return "指派";
    }
}
