package cn.gtmap.gtc.workflow.domain.manage;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/6/11
 * @Description: 任务实体（对外提供）
 *
 */

@SuppressWarnings("serial")
public class TaskData implements Serializable {

	/*****************待办任务*********************/
	// 任务id
	private String taskId;

	// 任务操作人
	private String taskAssigin;

	/************已办任务****************/

	//任务节点id
	private String taskKey;

	//任务节点名称
	private String taskName;

	//流程创建和任务开始时间
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startTime;

	//流程实例id
	private String processInstanceId;

	//流程实例名称
	private String processInstanceName;

	//流程结束时间
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endTime;

	//优先级分为1 2 3 4级 普通 50 一般 100 紧急 150 特别紧急 200
	private Integer priority;

	//发起人id
	private String startUserId;

	//流程定义id
	private String processDefId;

	//流程定义唯一标识
	private String processKey;

	//流程定义名称
	private String processDefName;

	//流程的状态 激活：1
	private String state;

	//委托状态
	private String delegation;

	//流程业务类别
	private String category;

	//流程业务类别描述
	private String categoryDec;

	//取回，退回原因
	private String reason;

	//执行实例id
	private String executionId;

	//流程表单key
	private String formKey;

	//认领状态
	private Integer claimStatus;

	//处理人name
	private String taskAssName;

	//流程创建人name
	private String procStartUserName;

	//超期状态
	private Integer taskTimeoutStatus;

	//流程的状态name
	private String stateName;

	//委托状态name
	private String delegationName;

	//优先级name
	private String priorityName;

	//认领状态name
	private String claimStatusName;

	//超期状态name
	private String taskTimeoutStatusName;

	//任务到期天数
	private Integer taskDueDays;

	//任务到期时数
	private Integer taskDueHours;

	//任务到期时间
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskDueDate;

	//意见信息
	private Map<String, String> comments;

	//任务超期天数
	private Integer taskTimeoutDays;

	//任务超期时数
	private Integer taskTimeoutHours;

	/**
	 * 1：退回任务 2：被退回任务
	 */
	private Integer backStatus;


	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getTaskAssigin() {
		return taskAssigin;
	}

	public void setTaskAssigin(String taskAssigin) {
		this.taskAssigin = taskAssigin;
	}

	public String getTaskKey() {
		return taskKey;
	}

	public void setTaskKey(String taskKey) {
		this.taskKey = taskKey;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public String getProcessInstanceId() {
		return processInstanceId;
	}

	public void setProcessInstanceId(String processInstanceId) {
		this.processInstanceId = processInstanceId;
	}

	public String getProcessInstanceName() {
		return processInstanceName;
	}

	public void setProcessInstanceName(String processInstanceName) {
		this.processInstanceName = processInstanceName;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	public String getStartUserId() {
		return startUserId;
	}

	public void setStartUserId(String startUserId) {
		this.startUserId = startUserId;
	}

	public String getProcessDefId() {
		return processDefId;
	}

	public void setProcessDefId(String processDefId) {
		this.processDefId = processDefId;
	}

	public String getProcessKey() {
		return processKey;
	}

	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}

	public String getProcessDefName() {
		return processDefName;
	}

	public void setProcessDefName(String processDefName) {
		this.processDefName = processDefName;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getDelegation() {
		return delegation;
	}

	public void setDelegation(String delegation) {
		this.delegation = delegation;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCategoryDec() {
		return categoryDec;
	}

	public void setCategoryDec(String categoryDec) {
		this.categoryDec = categoryDec;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getExecutionId() {
		return executionId;
	}

	public void setExecutionId(String executionId) {
		this.executionId = executionId;
	}

	public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	public Integer getClaimStatus() {
		return claimStatus;
	}

	public void setClaimStatus(Integer claimStatus) {
		this.claimStatus = claimStatus;
	}

	public String getTaskAssName() {
		return taskAssName;
	}

	public void setTaskAssName(String taskAssName) {
		this.taskAssName = taskAssName;
	}

	public String getProcStartUserName() {
		return procStartUserName;
	}

	public void setProcStartUserName(String procStartUserName) {
		this.procStartUserName = procStartUserName;
	}

	public Integer getTaskTimeoutStatus() {
		return taskTimeoutStatus;
	}

	public void setTaskTimeoutStatus(Integer taskTimeoutStatus) {
		this.taskTimeoutStatus = taskTimeoutStatus;
	}

	public String getStateName() {
		return stateName;
	}

	public void setStateName(String stateName) {
		this.stateName = stateName;
	}

	public String getDelegationName() {
		return delegationName;
	}

	public void setDelegationName(String delegationName) {
		this.delegationName = delegationName;
	}

	public String getPriorityName() {
		return priorityName;
	}

	public void setPriorityName(String priorityName) {
		this.priorityName = priorityName;
	}

	public String getClaimStatusName() {
		return claimStatusName;
	}

	public void setClaimStatusName(String claimStatusName) {
		this.claimStatusName = claimStatusName;
	}

	public String getTaskTimeoutStatusName() {
		return taskTimeoutStatusName;
	}

	public void setTaskTimeoutStatusName(String taskTimeoutStatusName) {
		this.taskTimeoutStatusName = taskTimeoutStatusName;
	}

	public Integer getTaskDueDays() {
		return taskDueDays;
	}

	public void setTaskDueDays(Integer taskDueDays) {
		this.taskDueDays = taskDueDays;
	}

	public Integer getTaskDueHours() {
		return taskDueHours;
	}

	public void setTaskDueHours(Integer taskDueHours) {
		this.taskDueHours = taskDueHours;
	}

	public Date getTaskDueDate() {
		return taskDueDate;
	}

	public void setTaskDueDate(Date taskDueDate) {
		this.taskDueDate = taskDueDate;
	}

	public Integer getTaskTimeoutDays() {
		return taskTimeoutDays;
	}

	public void setTaskTimeoutDays(Integer taskTimeoutDays) {
		this.taskTimeoutDays = taskTimeoutDays;
	}

	public Integer getTaskTimeoutHours() {
		return taskTimeoutHours;
	}

	public void setTaskTimeoutHours(Integer taskTimeoutHours) {
		this.taskTimeoutHours = taskTimeoutHours;
	}

	public Integer getBackStatus() {
		return backStatus;
	}

	public void setBackStatus(Integer backStatus) {
		this.backStatus = backStatus;
	}

	public Map<String, String> getComments() {
		return comments;
	}

	public void setComments(Map<String, String> comments) {
		this.comments = comments;
	}

	@Override
	public String toString() {
		return "TaskData{" +
				"taskId='" + taskId + '\'' +
				", taskAssigin='" + taskAssigin + '\'' +
				", taskKey='" + taskKey + '\'' +
				", taskName='" + taskName + '\'' +
				", startTime=" + startTime +
				", processInstanceId='" + processInstanceId + '\'' +
				", processInstanceName='" + processInstanceName + '\'' +
				", endTime=" + endTime +
				", priority=" + priority +
				", startUserId='" + startUserId + '\'' +
				", processDefId='" + processDefId + '\'' +
				", processKey='" + processKey + '\'' +
				", processDefName='" + processDefName + '\'' +
				", state='" + state + '\'' +
				", delegation='" + delegation + '\'' +
				", category='" + category + '\'' +
				", reason='" + reason + '\'' +
				", executionId='" + executionId + '\'' +
				", formKey='" + formKey + '\'' +
				", claimStatus=" + claimStatus +
				", taskAssName='" + taskAssName + '\'' +
				", procStartUserName='" + procStartUserName + '\'' +
				", taskTimeoutStatus=" + taskTimeoutStatus +
				", stateName='" + stateName + '\'' +
				", delegationName='" + delegationName + '\'' +
				", priorityName='" + priorityName + '\'' +
				", claimStatusName='" + claimStatusName + '\'' +
				", taskTimeoutStatusName='" + taskTimeoutStatusName + '\'' +
				", taskDueDays=" + taskDueDays +
				", taskDueHours=" + taskDueHours +
				", taskDueDate=" + taskDueDate +
				", taskTimeoutDays=" + taskTimeoutDays +
				", taskTimeoutHours=" + taskTimeoutHours +
				'}';
	}
}
