package cn.gtmap.gtc.workflow.domain.manage;

import java.util.Date;

public class ProcessInsWithProjectDto extends ProcessInsExtendDto {

    private String processInstanceName;     //流程实例的名称

    private String startActivityId;         //开始节点id

    private String startUserId;             //流程发起人编码(登录名)

    private Date startTime;                 //流程的启动时间

    private Date endTime;                 //流程结束时间

    private String deleteReason;            //流程的删除原因
    /**
     * 流程定义ID
     */
    private String procDefId;

    /**
     * 流程定义key
     */
    private String procDefKey;

    /**
     * 流程定义名称
     */
    private String procDefName;

    /**
     * 流程期限类型(D 按天,H 按小时,N 不限制)
     */
    private String procDueType = "D";

    /**
     * 流程期限
     */
    private Integer procDueLimit;
    /**
     * 流程到期时间
     */
    private Date procDueTime;

    /**
     * 发起人所属部门ID
     */
    private String startUserDep;

    /**
     * 流程发起人名称(中文名)
     */
    private String startUserName;

    /**
     * 流程超期量(单位由PROC_DUE_TYPE决定)
     */
    private Integer procTimeoutCount;

    /**
     * 流程超期状态(0未超期,1已超期)
     */
    private Integer procTimeoutStatus;

    /**
     * 流程状态(1正在运行，2结束， 3 挂起)
     */
    private Integer procStatus;

    /**
     * 业务类别
     */
    private String category;
    /**
     * 业务类别中文名
     */
    private String categoryName;

    public String getProcessInstanceName() {
        return processInstanceName;
    }

    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    public String getStartActivityId() {
        return startActivityId;
    }

    public void setStartActivityId(String startActivityId) {
        this.startActivityId = startActivityId;
    }

    public String getStartUserId() {
        return startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getDeleteReason() {
        return deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcDefName() {
        return procDefName;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    public String getProcDueType() {
        return procDueType;
    }

    public void setProcDueType(String procDueType) {
        this.procDueType = procDueType;
    }

    public Integer getProcDueLimit() {
        return procDueLimit;
    }

    public void setProcDueLimit(Integer procDueLimit) {
        this.procDueLimit = procDueLimit;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getProcDueTime() {
        return procDueTime;
    }

    public void setProcDueTime(Date procDueTime) {
        this.procDueTime = procDueTime;
    }

    public String getStartUserDep() {
        return startUserDep;
    }

    public void setStartUserDep(String startUserDep) {
        this.startUserDep = startUserDep;
    }

    public String getStartUserName() {
        return startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Integer getProcTimeoutCount() {
        return procTimeoutCount;
    }

    public void setProcTimeoutCount(Integer procTimeoutCount) {
        this.procTimeoutCount = procTimeoutCount;
    }

    public Integer getProcTimeoutStatus() {
        return procTimeoutStatus;
    }

    public void setProcTimeoutStatus(Integer procTimeoutStatus) {
        this.procTimeoutStatus = procTimeoutStatus;
    }

    public Integer getProcStatus() {
        return procStatus;
    }

    public void setProcStatus(Integer procStatus) {
        this.procStatus = procStatus;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
}
