package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.BaseResult;
import cn.gtmap.gtc.workflow.domain.manage.BackTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.FormPropertyDto;
import cn.gtmap.gtc.workflow.domain.manage.ForwardTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.UserTaskDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/7/11
 * @description 流程定义活动节点
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface FlowableNodeClient {

    /**
     * 判断是否是第一个或最后一个任务节点
     * @param taskId
     * @return
     */
    @GetMapping(value = "/process-nodes/task-iStartOrEnd")
    Map<String,Boolean> getFlag(@RequestParam(value = "taskId") String taskId);

    /**
     * 转发判断是下个节点是否是结束
     * @param taskId
     * @return
     */
    @GetMapping(value = "/process-nodes/forward/is-end-task")
    boolean isForwardEndEvent(@RequestParam(value = "taskId") String taskId);

    /**
     *
     * @param taskId 任务活动id
     * @return TaskNodeType.value();
     * @description 转发下个节点是，获取下个节点的节点类型
     */
    @GetMapping(value = "/process-nodes/forward/type")
    String getForwardNodeType(@RequestParam(value = "taskId") String taskId);

    /**
     * 根据任务id获取转发下个节点的方式
     * @param taskId
     * @return
     */
    @GetMapping("/process-nodes/forward/{taskId}/complete-mode")
    String getCompleteMode(@PathVariable("taskId") String taskId);

    /**
     *
     * @param taskId 任务活动id
     * @return TaskNodeType.value();
     * @description 根据任务id获取转发到下个节点列表
     */
    @GetMapping("/process-nodes/forward/tasks")
    List<ForwardTaskDto> getForwardUserTasks(@RequestParam("taskId") String taskId);


    /**
     * 根据任务id获取当前节点列表
     * @param taskId
     * @return
     */
    @GetMapping("/process-nodes/current/tasks")
    public ForwardTaskDto getCurrentTask(@RequestParam("taskId") String taskId);

    /**
     *
     * @param taskId 任务活动id
     * @description 根据任务id获取退回到上个节点列表
     */
    @GetMapping("/process-nodes/back/tasks")
    List<BackTaskDto> getBackUserTasks(@RequestParam("taskId") String taskId);

    /**
     * 判断是否允许退回
     */
    @GetMapping("/process-nodes/back/isAllow/{taskId}")
    BaseResult isAllowBack(@PathVariable(name="taskId")String taskId);

    /**
     * 获取流程退回的类型
     * @param taskId
     * @return
     */
    @RequestMapping(value = "/process-nodes/{taskId}/prorocess-back-type", method = RequestMethod.GET)
     String getProcessBackType(@PathVariable("taskId") String taskId);

    /**
     * 根据流程定义Key获取流程定义的所有人工节点
     */
    @GetMapping("/process-nodes/definition-key/user-tasks")
    List<UserTaskDto> getAllUserTaskByProcDefKey(@RequestParam("processDefKey") String processDefKey);

    /**
     * 根据流程定义id获取流程定义的所有任务节点
     */
    @GetMapping("/process-nodes/definition-id/user-tasks")
    List<UserTaskDto> getAllUserTaskByProcDefId(@RequestParam("processDefinitionId") String processDefinitionId);

    /**
     * 根据流程实例id获取流程定义的所有任务节点
     */
    @GetMapping("/process-nodes/process-ins-id/user-tasks")
    List<UserTaskDto> getAllUserTaskByProcInsId(@RequestParam("processInstanceId") String processInstanceId);

    /**
     * 根据流程实例id获取流程定义的当前任务节点
     */
    @GetMapping("/process-nodes/process-ins-id/current-user-tasks")
    List<UserTaskDto> getCurrentUserTaskByProcInsId(@RequestParam("processInstanceId") String processInstanceId);

    /**
     * 根据流程实例id获取流程定义的上一个任务节点
     */
    @GetMapping("/process-nodes/process-ins-id/before-user-tasks")
    List<UserTaskDto> getBeforeUserTaskByProcInsId(@RequestParam("processInstanceId") String processInstanceId);

    /**
     * 根据流程实例id获取流程定义的下一个任务节点
     */
    @GetMapping("/process-nodes/process-ins-id/next-user-tasks")
    List<UserTaskDto> getNextUserTaskByProcInsId(@RequestParam("processInstanceId") String processInstanceId);

    /**
     * 根据任务id获取流程定义的所有任务节点
     */
    @GetMapping(value = "/process-nodes/task/user-tasks")
    List<UserTaskDto> getAllUserTaskByTaskId(@RequestParam("taskId") String taskId);

    /**
     * 根据任务id获取流程定义的下个任务节点
     */
    @GetMapping("/process-nodes/task/next-user-tasks")
    List<UserTaskDto> getNextUserTaskByTaskId(@RequestParam("taskId") String taskId);

    /**
     * 判断是否允许取回
     */
    @GetMapping("/process-nodes/fetchBack/isAllow/{taskId}")
    BaseResult isAllowFetchBack(@PathVariable("taskId")String taskId);

    /**
     * 根据任务id获取当前节点的扩展属性
     * @param taskId 任务id
     * @return
     */
    @RequestMapping(value = "/process-nodes/{taskId}/local-variable", method = RequestMethod.GET)
    public List<FormPropertyDto> getLocalvariableBpmnModel(@PathVariable("taskId") String taskId);
}
