package cn.gtmap.gtc.workflow.clients.define.v1;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

/**
 * @author zhouk
 * @Title: ImageClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/7/259:03
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface ImageClient {

    /**
     * 根据流程定义的ID获取字节流
     *
     * @param processId
     * @param
     * @throws Throwable
     */
    @RequestMapping(value = "/images/{processId}/process-byte", method = RequestMethod.GET)
    ResponseEntity<byte[]> getBPMImageByte(@PathVariable("processId") String processId);

    /**
     * 根据任务ID获取字节流
     *
     * @param taskId
     * @throws IOException
     * @throws Exception
     */
    @RequestMapping(value = "/images/{taskId}/task-byte", method = RequestMethod.GET)
    ResponseEntity<byte[]> imageHighLightedByte(@PathVariable("taskId") String taskId);

    /**
     * 根据流程实例ID获取字节流
     *
     * @param processInsId
     * @throws IOException
     * @throws Exception
     */
    @RequestMapping(value = "/images/{processInsId}/processIns-byte", method = RequestMethod.GET)
    ResponseEntity<byte[]> imageProcessInsByte(@PathVariable("processInsId") String processInsId);

    /**
     * 根据流程模版ID获取流
     * @param modelId
     * @param
     * @throws IOException
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "/images/{modelId}/model-byte", method = RequestMethod.GET)
    public  ResponseEntity<byte[]> getImageByteByModelId(@PathVariable("modelId")String modelId);
}
