package cn.gtmap.gtc.workflow.enums.task;

import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/6
 * @description
 */
public enum TimeOutStatus {

    NOT_OVERDUE(0, "未超期"),

    OVERDUE(1,"超期");

    private Integer value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    TimeOutStatus(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public static String getTimeOutName(Integer value){
        if (value == null || value == 0) {
            return "未超期";
        }
        return "超期";
    }

    public static TimeOutStatus getStatus(Date startTime, Date endTime) {
        if (endTime == null) {
            endTime = new Date();
        }
        if (startTime != null) {
            if (endTime.getTime() > startTime.getTime()) {
                return OVERDUE;
            }
        }
        return NOT_OVERDUE;
    }
}
