package cn.gtmap.gtc.workflow.enums.task;

import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;

public enum FlowElementType {


    /**
     * 用户任务
     */
    USER_TASK("UserTask"),

    /*
     * Http 服务节点
     * */
    HTTP_SERVICE_TASK("HttpTask"),

    /**
     * 脚本服务
     */
    SCRIPT_TASK("ScriptTask"),

    /**
     * java服务
     */
    SERVICE_TASK("ServiceTask"),

    /**
     * 业务规则任务
     */
    BUSINESS_RULE("BusinessRule"),

    /**
     * 接受任务
     */
    RECEIVE_TASK("ReceiveTask"),

    /**
     *手工任务
     */
    MANUAL_TASK("ManualTask"),

    /**
     * 邮件任务
     */
    MAIL_TASK("MailTask"),

    /**
     * camel任务
     */
    CAMEL_TASK("CamelTask"),

    /**
     * mule任务
     */
    MULE_TASK("MuleTask"),

    /**
     * shell 命令任务
     */
    SHELL_TASK("ShellTask"),

    /**
     *dmn 决策任务
     */
    DECISION_TASK("DecisionTask");

    private final String value;

    FlowElementType(String v){
        value = v;
    }

    public String value() {
        return value;
    }

    public static ArrayList<String> ServiceTasks(){
        ArrayList<String> ServiceTaskList=new ArrayList<>();
        ServiceTaskList.add("UserTask");
        ServiceTaskList.add("HttpTask");
        ServiceTaskList.add("ScriptTask");
        ServiceTaskList.add("ServiceTask");
        ServiceTaskList.add("BusinessRule");
        ServiceTaskList.add("ReceiveTask");
        ServiceTaskList.add("ManualTask");
        ServiceTaskList.add("MailTask");
        ServiceTaskList.add("MuleTask");
        ServiceTaskList.add("ShellTask");
        ServiceTaskList.add("DecisionTask");
        return ServiceTaskList;
    }

    public static boolean isContainServiceTask(String value){
        if(!StringUtils.isEmpty(value)){
            ArrayList<String> ServiceTasks=ServiceTasks();
            if(ServiceTasks.contains(value)){
                return true;
            }
        }
        return false;
    }





}
