package cn.gtmap.gtc.workflow.enums.rabbitmq;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/27
 * @description
 */
public enum WorkflowMsgType {

    DELETE("PROCESS_DELETE", "流程删除"),
    CLOSE("PROCESS_CLOSE", "流程关闭"),
    ABANDONED("PROCESS_ABANDONED", "流程废弃"),
    HANG("PROCESS_HANG", "流程挂起"),
    ACTIVATION("PROCESS_ACTIVATION", "流程激活"),
    DISABLED("PROCESS_DISABLED", "流程锁定"),
    DELEGATION("PROCESS_DELEGATION", "流程委托,代理"),
    ENABLED("PROCESS_ENABLED", "流程解除"),
    CLAIM("NEW_CLAIM", "待认领任务"),
    COMPLETE("NEW_TASK", "待办任务"),
    BACK("TASK_BACK", "退回任务"),
    FETCH_BACK("TASK_FETCH_BACK", "取回任务"),
    END("PROCESS_END", "流程办结"),
    TASK_TIME_OUT("TASK_TIME_OUT", "任务超期");

    private String value;

    private String remark;

    public String getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    WorkflowMsgType(String value, String remark) {
        this.value = value;
        this.remark = remark;
    }
}
