package cn.gtmap.gtc.workflow.enums.manage;

/**
 * @Classname cn.gtmap.gtc.workflow.enums.manage
 * @Description 请求的判断条件
 * @Date 2020/3/20 14:32
 * @Created by zhouk
 */
public enum QueryJudge {

    /**
     * 相等查询
     */
    EQUALS("eq", "相等查询"),

    /**
     * 不相等查询
     */
    NOT_EQUALS("notEq", "不相等查询"),

    /**
     * 相似查询
     */
    LIKE("like", "相似查询"),

    /**
     * 相似查询
     */
    LIKES("likes", "多个相似查询"),

    /**
     * 范围查询
     */
    IN("in", "范围查询"),


    /**
     * 大于查询
     */
    DATE_GT("gt", "大于查询"),

    /**
     * 大于等于询
     */
    DATE_EGT("egt", "大于等于"),

    /**
     * 的小于
     */
    DATE_LT("lt", "小于"),

    /**
     * 小于等于
     */
    DATE_ELT("elt", "小于等于"),

    /**
     * 排序
     */
    ORDER("order", "排序"),


    /**
     * 或条件的相等查询
     */
    OR_EQUALS("or_eq","或条件的相等查询"),

    /**
     * 或条件的相等查询
     */
    OR_LIKE("or_like","或条件的相似查询"),

    /**
     * 或条件的相等查询
     */
    OR_IN("or_in", "或条件的范围查询"),

    /**
     * 排除范围内
     */
    NOT_IN("not_in","排除范围内"),


    /**
     * 特殊
     */
    SPECIAL("special", "特殊处理");




    private final String value;

    private final String remark;

    QueryJudge(String value, String remark) {
        this.value = value;
        this.remark = remark;
    }


    public String value() {
        return value;
    }
}
