package cn.gtmap.gtc.workflow.domain.manage;

import java.io.Serializable;
import java.util.Date;

/**
 * 流程统计BEAN
 *
 * @author fjj
 */
public class StatisticsProcDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private String id;

    /**
     * 流程实例ID
     */
    private String procInsId;

    /**
     * 流程定义ID
     */
    private String procDefId;

    /**
     * 流程定义key
     */
    private String procDefKey;

    /**
     * 流程期限类型(D 按天,H 按小时,N 不限制)
     */
    private String procDueType = "D";

    /**
     * 流程期限
     */
    private Integer procDueLimit;

    /**
     * 流程开始时间
     */
    private Date procStartTime;

    /**
     * 流程到期时间
     */
    private Date procDueTime;

    /**
     * 流程结束时间
     */
    private Date procEndTime;

    /**
     * 流程发起人编码(登录名)
     */
    private String startUserId;

    /**
     * 发起人所属部门ID
     */
    private String startUserDep;

    //发起人行政区划编码
    private String startRegionCode;

    /**
     * 流程发起人名称(中文名)
     */
    private String startUserName;

    /**
     * 流程超期量(单位由PROC_DUE_TYPE决定)
     */
    private Integer procTimeoutCount;

    /**
     * 流程超期状态(0未超期,1已超期)
     */
    private Integer procTimeoutStatus;

    /**
     * 流程状态(1正在运行，2结束)
     */
    private Integer procStatus;

    /**
     * 业务类别
     */
    private String category;

    /**
     * 操作模式（新增还是更新），用于判断该执行何种逻辑：1新增，2更新
     */
    private int mode;

    /*
    * 操作时间
    * */
    private Date optTime;

    /*
     *  最后一次计算时间
     * */
    private Date reckonTime;

    /*
     *  统计时间 （分钟）
     * */
    private Long statisticsTime;

    /*
     *  工作日ID
     * */
    private String workId;

    /**
     * 流程定义名称
     */
    private String procDefName;

    /**
     * 流程实例优先级
     */
    private Integer priority;

    /**
     * 流程锁定时间合并（分钟）
     */
    private Long sumLockTime;

    /**
     * 全部统计时间，除掉非工作日（分钟）
     */
    private Long fullStatisticsTime;

    /**
     * 加急原因
     */
    private String procUrgentReason;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProcInsId() {
        return procInsId;
    }

    public void setProcInsId(String procInsId) {
        this.procInsId = procInsId;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcDueType() {
        return procDueType;
    }

    public void setProcDueType(String procDueType) {
        this.procDueType = procDueType;
    }

    public Integer getProcDueLimit() {
        return procDueLimit;
    }

    public void setProcDueLimit(Integer procDueLimit) {
        this.procDueLimit = procDueLimit;
    }

    public Date getProcStartTime() {
        return procStartTime;
    }

    public void setProcStartTime(Date procStartTime) {
        this.procStartTime = procStartTime;
    }

    public Date getProcDueTime() {
        return procDueTime;
    }

    public void setProcDueTime(Date procDueTime) {
        this.procDueTime = procDueTime;
    }

    public Date getProcEndTime() {
        return procEndTime;
    }

    public void setProcEndTime(Date procEndTime) {
        this.procEndTime = procEndTime;
    }

    public String getStartUserId() {
        return startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public String getStartUserDep() {
        return startUserDep;
    }

    public void setStartUserDep(String startUserDep) {
        this.startUserDep = startUserDep;
    }

    public String getStartUserName() {
        return startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Integer getProcTimeoutCount() {
        return procTimeoutCount;
    }

    public void setProcTimeoutCount(Integer procTimeoutCount) {
        this.procTimeoutCount = procTimeoutCount;
    }

    public Integer getProcTimeoutStatus() {
        return procTimeoutStatus;
    }

    public void setProcTimeoutStatus(Integer procTimeoutStatus) {
        this.procTimeoutStatus = procTimeoutStatus;
    }

    public Integer getProcStatus() {
        return procStatus;
    }

    public void setProcStatus(Integer procStatus) {
        this.procStatus = procStatus;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getMode() {
        return mode;
    }

    public Date getOptTime() {
        return optTime;
    }

    public void setOptTime(Date optTime) {
        this.optTime = optTime;
    }

    public StatisticsProcDto setMode(int mode) {
        this.mode = mode;
       return this;
    }

    public Date getReckonTime() {
        return reckonTime;
    }

    public void setReckonTime(Date reckonTime) {
        this.reckonTime = reckonTime;
    }

    public String getWorkId() {
        return workId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }

    public Long getStatisticsTime() {
        return statisticsTime;
    }

    public void setStatisticsTime(Long statisticsTime) {
        this.statisticsTime = statisticsTime;
    }

    public String getStartRegionCode() {
        return startRegionCode;
    }

    public void setStartRegionCode(String startRegionCode) {
        this.startRegionCode = startRegionCode;
    }

    public String getProcDefName() {
        return procDefName;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Long getSumLockTime() {
        return sumLockTime;
    }

    public void setSumLockTime(Long sumLockTime) {
        this.sumLockTime = sumLockTime;
    }

    public Long getFullStatisticsTime() {
        return fullStatisticsTime;
    }

    public void setFullStatisticsTime(Long fullStatisticsTime) {
        this.fullStatisticsTime = fullStatisticsTime;
    }

    public String getProcUrgentReason() {
        return procUrgentReason;
    }

    public void setProcUrgentReason(String procUrgentReason) {
        this.procUrgentReason = procUrgentReason;
    }

}
