package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @Classname cn.gtmap.gtc.workflow.clients.manage
 * @Description TODO
 * @Date 2020/4/7 19:56
 * @Created by zhouk
 */
@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessInsCustomExtendClient {

    /**
     * 根据procInsId 获取流程扩展属性
     * @param procInsId
     */
    @GetMapping("/processInsId-custom-extend/{procInsId}")
    public List<Map<String, Object>> getProcessInsCustomExtend(@PathVariable("procInsId") String procInsId);

    /**
     * 保存流程自定义属性(入参别名)
     * @param requestConditionList 符合数据库规范的定义列名称 （别名）
     */
    @PostMapping("/processInsId-custom-extend/alias")
    public void saveProcessInsCustomExtend(@RequestBody List<RequestCondition> requestConditionList,
                                           @RequestParam(required = false, value = "procInsId") String procInsId);
    /**
     *  添加流程扩展属性
     * @param params key: 表的列名 object：属性
     */
    @PostMapping("/processInsId-custom-extend/column-name")
    public void addProcessInsCustomExtend(@RequestBody Map<String, Object> params);
    /**
     *  更新流程扩展属性
     * @param params key: 表列名称  object：属性
     */
    @PatchMapping("/processInsId-custom-extend/column-name")
    public void updateProcessInsCustomExtend(@RequestParam("procInsId")String procInsId, @RequestBody Map<String, Object> params);

    /**
     *  批量保存流程扩展属性，（流程实例ID必须要传，数据库有旧更新，没有添加）
     * @param paramsList key: 表列名称  object：属性
     */
    @PostMapping("/processInsId-custom-extend/batch-column-name")
    public void batchSaveProcessInsCustomExtend(@RequestBody List<Map<String, Object>> paramsList);

    /**
     * 根据procInsId 删除 流程扩展属性
     * @param procInsId
     */
    @PatchMapping("/processInsId-custom-extend/{procInsId}")
    public void delProcessInsCustomExtend(@PathVariable("procInsId") String procInsId);
}
