package cn.gtmap.gtc.workflow.clients.define.v2;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.workflow.domain.define.Work;
import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhouk
 * @Title: WorkDayClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/9/2617:31
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v2")
public interface WorkDayClient {

    /**
     * 获取工作日的设置列表
     * @return
     */
    @RequestMapping(
            value = {"/works/Condition"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public PageResult<Work> getWorksByCondition(@RequestParam("name") String name,
                                                Pageable pageable);

    /**
     * 根據工作日設置的id獲取工作日的詳情(分页)
     * @param workId
     * @return
     */
    @RequestMapping(
            value = {"/works/{workId}/work-days/page"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public PageResult<WorkDay> getWorkDaysByPage(@PathVariable("workId")String workId, Pageable pageable);
}
