package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.Work;
import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.domain.define.WorkDayRelation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhouk
 * @Title: WorkDayClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/7/1214:26
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface WorkDayClient {

    /**
     * 获取工作日的设置列表
     *
     * @return
     */
    @RequestMapping(
            value = {"/works"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<Work> getWorks();

    /**
     * 获取工作日的设置列表
     *
     * @return
     */
    @RequestMapping(
            value = {"/works/Condition"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public Page<Work> getWorksByCondition(@RequestParam("name") String name,
                                          Pageable pageable);


    /**
     * 保存工作日的设置
     *
     * @param work
     */
    @RequestMapping(
            value = {"/works"},
            method = {RequestMethod.POST}
    )
    public Work saveWork(@RequestBody Work work);

    /**
     * 删除工作日的设置
     *
     * @param id
     */
    @RequestMapping(
            value = {"/works/{id}"},
            method = {RequestMethod.DELETE}
    )
    public void delWork(@PathVariable("id") String id);

    /**
     * 获取某个工作日的设置
     *
     * @param id
     * @return
     */
    @RequestMapping(
            value = {"/works/{id}"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public Work getWork(@PathVariable("id") String id);

    /**
     * 删除某个工作日的和关联子表
     *
     * @param id
     */
    @RequestMapping(
            value = {"/works/{id}/sub"},
            method = {RequestMethod.DELETE}
    )
    public void delWorkAndSub(@PathVariable("id") String id);

    /**
     * 根據工作日設置的id獲取工作日的詳情
     *
     * @param workId
     * @return
     */
    @RequestMapping(
            value = {"/works/{workId}/work-days"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<WorkDay> getWorkDays(@PathVariable("workId") String workId,
                                     @RequestParam("startDate") String startDate,
                                     @RequestParam("endDate") String endDate);

    /**
     * 根據工作日設置的id獲取工作日的詳情(分页)
     *
     * @param workId
     * @return
     */
    @RequestMapping(
            value = {"/works/{workId}/work-days/page"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public Page<WorkDay> getWorkDaysByPage(@PathVariable("workId") String workId, Pageable pageable);

    /**
     * 保存一个工作日详情确保唯一
     *
     * @param workDay
     */
    @RequestMapping(
            value = {"/work-days/only"},
            method = {RequestMethod.POST}
    )
    public void saveWorkDay(@RequestBody WorkDay workDay);

    /**
     * 刪除工作日的設置詳情
     *
     * @param ids
     */
    @RequestMapping(
            value = {"/work-days"},
            method = {RequestMethod.DELETE}
    )
    public void delWorkDay(@RequestBody List<String> ids);

    /**
     * 獲取某個工作日的詳情
     *
     * @param id
     * @return
     */
    @RequestMapping(
            value = {"/work-days/{id}"},
            method = {RequestMethod.GET}
    )
    public WorkDay getWorkDay(@PathVariable("id") String id);

    /**
     * 根據工作日設置ID刪除所有關聯工作日詳情
     *
     * @param workId
     */
    @RequestMapping(
            value = {"/work-days/{workId}"},
            method = {RequestMethod.DELETE}
    )
    public void delWorkDayByWorkId(@PathVariable("workId") String workId);

    /**
     * 根據流程實例ID獲取相關聯的工作日詳情的數據
     *
     * @param relationId
     * @return
     */
    @RequestMapping(
            value = {"/work-days/workDays"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<WorkDay> findWorkDaysByRelationId(@RequestParam("relationId") String relationId,
                                                  @RequestParam("type") Integer type);

    /**
     * 保存工作日設置關聯流程實例
     *
     * @param workDayRelation
     */
    @RequestMapping(
            value = {"/works/relation"},
            method = {RequestMethod.POST}
    )
    public void saveWorkRelation(@RequestBody WorkDayRelation workDayRelation);

    /**
     * 根据关联id查询工作时间关联数据
     * @param relationId 关联id
     * @param type 关联时间模板类型(0：流程关联work，1：人员关联work)
     */
    @RequestMapping(
            value = {"/workday-relation/workDayRelation"},
            method = {RequestMethod.GET}
    )
    WorkDayRelation findWorkDayRelation(@RequestParam("relationId") String relationId,
                                        @RequestParam("type") Integer type);

    /**
     * 根據Id刪除關聯
     *
     * @param id
     */
    @RequestMapping(
            value = {"/work_relation/{id}"},
            method = {RequestMethod.DELETE}
    )
    public void delWorkRelation(@PathVariable("id") String id);

    /**
     * 批量保存工作日的详情
     */
    @RequestMapping(
            value = {"/work-days/batch"},
            method = {RequestMethod.POST}
    )
    public void batchSaveWorkdays(@RequestBody List<WorkDay> WorkDays);


    /**
     * 批量保存工作日的详情
     */
    @RequestMapping(
            value = {"/work-days/batch-not-filter"},
            method = {RequestMethod.POST}
    )
    public void batchSaveWorkdaysAndNotFilter(@RequestBody List<WorkDay> WorkDays);

    /**
     * 根据工作日Id 以及开始和结束的时间获取数目
     *
     * @param workId
     * @param sDay
     * @param eDay
     * @return
     */
    @RequestMapping(
            value = {"/work-days/workday-count"},
            method = {RequestMethod.GET}
    )
    public Integer getWorkDayCount(@RequestParam("workId") String workId,
                                   @RequestParam("sDay") String sDay, @RequestParam("eDay") String eDay);

    /**
     * 根据工作日Id 以及开始和结束的时间删除工作日的详情
     *
     * @param workId
     * @param sDay
     * @param eDay
     * @return
     */
    @RequestMapping(
            value = {"/work-days/batch"},
            method = {RequestMethod.DELETE}
    )
    public void batchDelWorkDay(@RequestParam("workId") String workId,
                                @RequestParam("sDay") String sDay, @RequestParam("eDay") String eDay);



    /**
     * 根据工作日设置的id获取工作日的详情
     * @param workId 工作日id
     * @return 返回工作日详情
     */
    @RequestMapping(value = "/works/{workId}/work-days/list",method = {RequestMethod.GET},produces = {"application/json"})
    public List<WorkDay> listWorkDays(@PathVariable("workId") String workId);
}
