package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import cn.gtmap.gtc.workflow.domain.rso.CaseModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author zhouk
 * @Title: CmmnModelClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/12/314:20
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface CmmnModelClient {

    /**
     * 根据条件获取case的列表
     * @return
     */
    @RequestMapping(
            value = {"/case-models"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<CaseModel> getDecisionTables(@RequestParam(value = "filter",required = false)String filter,
                                             @RequestParam(value = "excludeId",required = false)String excludeId);

    /**
     * 模型的下载
     * @param modelId
     */
    @RequestMapping(
            value = {"/case-models/{modelId}/cmmn"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]> getProcessModelBpmn20Xml(@PathVariable("modelId") String modelId);

    /**
     * 历史的模型的下载
     * @param modelId
     * @param modelHistoryId
     */
    @RequestMapping(
            value = {"/case-models/{modelId}/history/{modelHistoryId}/cmmn"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]> getHistoricProcessModelBpmn20Xml(@PathVariable("modelId") String modelId, @PathVariable("modelHistoryId") String modelHistoryId);
    /**
     *BPMN的文件的上传
     * @param file
     * @return
     */
    @RequestMapping(
            value = {"/case-models/upload"},
            method = {RequestMethod.POST},
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = MediaType.MULTIPART_FORM_DATA_VALUE
    )
    public ModelRepresentationView importCaseModel(@RequestParam("userId")String userId, @RequestPart("file") MultipartFile file);

    /**
     *BPMN的文件的上传（IE）
     * @param file
     * @return
     */
    @RequestMapping(
            value = {"/case-models/upload/text"},
            method = {RequestMethod.POST}
    )
    public String importCaseModelText(@RequestParam("userId")String userId,@RequestParam("file") MultipartFile file);

    /**
     *CMMN文件的部署
     * @return
     */
    @RequestMapping(
            value = {"/case-models/{modelId}/deployment"},
            method = {RequestMethod.GET}
    )
    public void deploymentCmmn(@PathVariable("modelId")String modelId);
}
