package cn.gtmap.gtc.workflow.enums.statistics;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/5/2
 * @description
 */
public enum  DateType {
    YEAR("year", "yyyy"),
    MONTH("month", "yyyy-MM"),
    WEEK("week","yyyy-MM-dd"),
    DAY("day","yyyy-MM-dd");

    private String name;
    private String format;

    DateType(String name, String format){
        this.name = name;
        this.format = format;
    }

    public static DateType enumValue(String dateType) {
        if ("year".equalsIgnoreCase(dateType)){
            return YEAR;
        }
        if ("month".equalsIgnoreCase(dateType)){
            return MONTH;
        }
        if ("week".equalsIgnoreCase(dateType)){
            return WEEK;
        }
        if ("day".equalsIgnoreCase(dateType)){
            return DAY;
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public String getFormat() {
        return format;
    }
}
