package cn.gtmap.gtc.workflow;

/**
 * .Constant
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/21 11:36
 */
public final class Constant {

    public Constant() {
    }

    public static final String ALL_ROLE = "allRole";
    /**
     * 用户ID Key
     */
    public static final String USER_ID = "userId";

    public static final int ADMIN_USER = 1;

    /**
     * 文件后缀
     */
    public static final String SUFFIX_SHP = ".shp";

    public static final String SUFFIX_ZIP = ".zip";

    public static final String SUFFIX_CPG = ".cpg";

    /**
     * 数据集名称
     */
    public static final String CHARSET_GBK = "gbk";

    public static final String CHARSET_UTF8 = "utf-8";

    /**
     * 分页
     */
    public static final String PAGE = "page";

    public static final String SIZE = "size";

    /**
     * 数字(字符串)
     */
    public static final String STR_ZERO = "0";

    public static final String STR_ONE = "1";

    public static final String STR_TWO = "2";

    public static final String STR_THREE = "3";

    public static final String STR_FOUR = "4";

    public static final String STR_FIVE = "5";

    /**
     * 数字（整形）
     */
    public static final int NUM_ZERO = 0;

    public static final int NUM_ONE = 1;

    public static final int NUM_TWO = 2;

    public static final int NUM_THREE = 3;

    public static final int NUM_FOUR = 4;

    public static final int NUM_FIVE = 5;

    public static final String EN_FULL_STOP = ".";

    public static final String EN_QUESTION_MARK = "?";

    public static final String EN_COMMA = ",";

    public static final String EN_URL_CONNECTOR = "&";

    public static final String EN_COLON = ":";

    public static final String EN_FORWARD_SLASH = "/";

    public static final String EN_BACK_SLASH = "\\";

    public static final String EN_LEFT_BRACE = "{";

    public static final String EN_RIGHT_BRACE = "}";

    /**
     * MIME常见类型
     */
    public static final String MIME_TYPE_IMAGE_PNG = "image/png";

    public static final String MIME_TYPE_ZIP = "application/zip";

    public static final String MIME_TYPE_JSON = "application/json";

    /**
     * Map初始化大小
     */
    public static final int MAP_SIZE_SMALL = 5;

    public static final int MAP_SIZE_DEFAULT = 16;

    /**
     * 默认时间格式
     */
    public static final String DEFAULT_TIME_FORMATE = "HH:mm:ss";

    /**
     * 默认日期格式
     */
    public static final String DEFAULT_DATE_FORMATE = "yyyy-MM-dd";

    /**
     * 默认日期时间格式
     */
    public static final String DEFAULT_DATETIME_FORMATE = "yyyy-MM-dd HH:mm:ss";

    /**
     * 日期时间格式
     */
    public static final String SHORT_DATETIME_FORMATE = "yyyyMMddHHmmss";

    /**
     *
     */
    public static final String ACCESS_CONTROL_ALLOW_ORIGN = "Access-Control-Allow-Origin";

    public static final int MODE_INSERT = 1;

    public static final int MODE_UPDATE = 2;

    public static final int MODE_SYNC = 3;

    public static final int MODE_DELETE = 4;

    @Deprecated
    public static final int MODE_SYNC_ES = 5;

    public static final int MODE_AUTO_COMPLETE = 6;
    /**
     * 节点自动转发(节点自动转发)
     */
    public static final int NODE_AUTO_COMPLETE = 7;

    public static long B_UTC = 28800000l;

    public static final String   FLOWABLE_OP_LOG_PARAM_TASKID = "taskId";
    public static final String   FLOWABLE_OP_LOG_PARAM_TASKIDS = "taskIds";
    public static final String   FLOWABLE_OP_LOG_PARAM_INSTANCEID = "processInstanceId";

}
