package cn.gtmap.gtc.workflow.utils.manager;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.elasticsearch.constant.NormalConstant;
import cn.gtmap.gtc.workflow.enums.manage.QueryJudge;
import cn.gtmap.gtc.workflow.enums.manage.TaskQueryKey;
import cn.gtmap.gtc.workflow.enums.manage.TaskStatusQueryEqEnum;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @Classname cn.gtmap.gtc.workflow.manage.utils.project
 * @Description es 查询拼接json 的条件
 * @Date 2020/5/18 20:03
 * @Created by zhouk
 */
public class EsSearchJsonUtils {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private final Logger logger = LoggerFactory.getLogger(EsSearchJsonUtils.class);

    /**
     * es 组合条件查询
     *
     * @param requestConditions
     * @return
     */
    public static JSONObject spliceBoolCommomJson(List<RequestCondition> requestConditions, JSONObject whereJson,
                                                  String databaseType) {
        JSONObject queryJson = new JSONObject();

        JSONArray andJson = new JSONArray();    //and 的条件
        JSONArray notJson = new JSONArray();    //not 的条件
        JSONArray orderJson = new JSONArray();  //排序 的条件
        if (!CollectionUtils.isEmpty(requestConditions)) {
            requestConditions.forEach(requestCondition -> {
                if (!StringUtils.isEmpty(requestCondition.getRequestJudge())) {
                    handleValueAndKey(requestCondition, databaseType);

                    if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceCommomJson(requestCondition, NormalConstant.STR_TERM));
                    } else if (QueryJudge.LIKE.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceLikeJson(requestCondition));
                    } else if (QueryJudge.IN.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceCommomJson(requestCondition, NormalConstant.STR_TERMS));
                    } else if (QueryJudge.DATE_LT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceRanageJson(requestCondition, QueryJudge.DATE_LT.value()));
                    } else if (QueryJudge.DATE_ELT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceRanageJson(requestCondition, "lte"));
                    } else if (QueryJudge.DATE_EGT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceRanageJson(requestCondition, "gte"));
                    } else if (QueryJudge.DATE_GT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add(spliceRanageJson(requestCondition, QueryJudge.DATE_GT.value()));
                    } else if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
                        orderJson.add(spliceOrderJson(requestCondition));
                    } else if (QueryJudge.NOT_EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        notJson.add(spliceCommomJson(requestCondition, NormalConstant.STR_TERM));
                    } else if (QueryJudge.NOT_IN.value().equals(requestCondition.getRequestJudge())) {
                        notJson.add(spliceInJson(requestCondition));
                    } else if (QueryJudge.SPECIAL.value().equals(requestCondition.getRequestJudge())) {
                        spliceSpecialCommomJSON(requestCondition, andJson, notJson);
                    }
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " 判断条件不可为空!");
                }
            });
        }
        queryJson.put("query", new JSONObject() {{
            put(NormalConstant.STR_BOOL, new JSONObject() {{
                if (andJson.size() > 0) {
                    put(NormalConstant.STR_MUSt, andJson);
                }
                if (notJson.size() > 0) {
                    put(NormalConstant.STR_MUStNOT, notJson);
                }
                if (whereJson != null && !whereJson.isEmpty()) {
                    put(NormalConstant.STR_FILTER, whereJson);
                }
            }});
        }});
        if (orderJson.size() > 0) {
            queryJson.put(NormalConstant.STR_SORT, orderJson);
        }
        return queryJson;
    }

    /**
     * 对条件key 和 vaule值处理
     *
     * @param requestCondition
     * @param databaseType
     * @return
     */
    private static void handleValueAndKey(RequestCondition requestCondition, String databaseType) {
        Logger logger = LoggerFactory.getLogger(EsSearchJsonUtils.class);
        if (RequestKeyUtils.QUERY_VALUE_TYPR_STRING.equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.
                get(requestCondition.getRequestKey())) ||
                RequestKeyUtils.QUERY_VALUE_TYPR_STRING.equalsIgnoreCase(RequestKeyUtils.getProcKeyType.
                        get(requestCondition.getRequestKey())) ||
                RequestKeyUtils.QUERY_VALUE_TYPR_STRING.equalsIgnoreCase(DatabaseTypeUtils
                        .boolDataType(requestCondition.getRequestKey(), databaseType))
        ) {

            requestCondition.setRequestKey(requestCondition.getRequestKey() + ".keyword");
        } else if (RequestKeyUtils.QUERY_VALUE_TYPR_INT.equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.
                get(requestCondition.getRequestKey())) ||
                RequestKeyUtils.QUERY_VALUE_TYPR_INT.equalsIgnoreCase(RequestKeyUtils.getProcKeyType.
                        get(requestCondition.getRequestKey())) ||
                RequestKeyUtils.QUERY_VALUE_TYPR_INT.equalsIgnoreCase(DatabaseTypeUtils
                        .boolDataType(requestCondition.getRequestKey(), databaseType))
        ) {
            //不处理number类型


        } else if (RequestKeyUtils.QUERY_VALUE_TYPR_DATE.equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.
                get(requestCondition.getRequestKey()))
                || RequestKeyUtils.QUERY_VALUE_TYPR_DATE.equalsIgnoreCase(RequestKeyUtils.getProcKeyType.
                get(requestCondition.getRequestKey()))
                || RequestKeyUtils.QUERY_VALUE_TYPR_INT.equalsIgnoreCase(DatabaseTypeUtils
                .boolDataType(requestCondition.getRequestKey(), databaseType))
        ) {
            try {
                if (DatabaseTypeUtils.QUERY_DATE_SET.contains(requestCondition.getRequestKey())) {
                    requestCondition.setRequestKey(DatabaseTypeUtils.QUERY_DATE_MAP_COMMOM.
                            get(requestCondition.getRequestKey()) + "InLong");
                } else {
                    requestCondition.setRequestKey(requestCondition.getRequestKey() + "InLong");
                }
                Date date = sdf.parse(requestCondition.getRequestValue().toString());
                requestCondition.setRequestValue(date.getTime());
            } catch (Exception e) {
                logger.error("时间转换异常 :{}", e.getMessage());
            }

        }
    }

    /**
     * 通用 查询 拼接
     *
     * @param requestCondition
     * @param queryType
     * @return
     */
    private static JSONObject spliceCommomJson(RequestCondition requestCondition, String queryType) {
        JSONObject json = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            json.put(queryType, new JSONObject() {{
                put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
            }});
        }
        return json;
    }

    /**
     * 范围查询 拼接
     *
     * @param requestCondition
     * @return
     */
    private static JSONObject spliceRanageJson(RequestCondition requestCondition, String rangeType) {
        JSONObject rangeJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            rangeJson.put(NormalConstant.STR_RANGE, new JSONObject() {{
                put(requestCondition.getRequestKey(), new JSONObject() {{
                    put(rangeType, requestCondition.getRequestValue());
                }});
            }});
        }
        return rangeJson;
    }


    /**
     * like 查询 拼接
     *
     * @param requestCondition
     * @return
     */
    private static JSONObject spliceLikeJson(RequestCondition requestCondition) {
        JSONObject likeJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            requestCondition.setRequestValue("*" + requestCondition.getRequestValue() + "*");
            likeJson.put(NormalConstant.STR_WILDCARD, new JSONObject() {{
                put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
            }});
        }
        return likeJson;
    }


    /**
     * in 查询
     * @param requestCondition
     * @return
     */
    private static JSONObject spliceInJson(RequestCondition requestCondition) {
        JSONObject json = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            json.put(NormalConstant.STR_TERMS, new JSONObject() {{
                put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
            }});
        }
        return json;
    }


    /**
     * 排序拼接
     *
     * @param requestCondition
     * @return
     */
    private static JSONObject spliceOrderJson(RequestCondition requestCondition) {
        JSONObject orderJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            orderJson.put(requestCondition.getRequestKey(), new JSONObject() {{
                put(NormalConstant.STR_ORDER, requestCondition.getRequestValue());
            }});
        }
        return orderJson;
    }

    /**
     * 增加默认的排序
     *
     * @param whereJson
     * @param timeKey
     * @return
     */
    public static JSONObject spliceDefalutOrderJson(JSONObject whereJson, String priorityKey, String timeKey) {
        if (!whereJson.containsKey(NormalConstant.STR_SORT)) {
            whereJson.put(NormalConstant.STR_SORT, new JSONObject(new LinkedHashMap()) {{
                put(priorityKey, new JSONObject() {{
                    put(NormalConstant.STR_ORDER, "desc");
                }});
                put(timeKey, new JSONObject() {{
                    put(NormalConstant.STR_ORDER, "desc");
                }});
            }});
        }
        return whereJson;
    }


    /**
     * 特殊处理任务的状态
     *
     * @param requestCondition
     * @param andJson
     * @param notJson
     */
    private static void spliceSpecialCommomJSON(RequestCondition requestCondition, JSONArray andJson,
                                              JSONArray notJson) {
        if(!StringUtils.isEmpty(requestCondition.getRequestKey())){
           if (requestCondition.getRequestKey().equals(TaskQueryKey.TASK_STATUS.value())) {
                if (requestCondition.getRequestValue() != null) {
                    String type = requestCondition.getRequestValue().toString();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(type)) {
                        if (type.equals(TaskStatusQueryEqEnum.NORMAL.getValue())) {
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_TASK_STATUS, 1);
                                }});
                            }});
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_PROC_STARTTIME, 0);
                                }});
                            }});

                            notJson.add(new JSONObject() {{
                                put(NormalConstant.STR_EXISTS, new JSONObject() {{
                                    put(NormalConstant.STR_FIELD, EsSearchFieldConstant.ES_FIELD_BACK_STATUS);
                                }});
                            }});
                        } else if (type.equals(TaskStatusQueryEqEnum.BACK.getValue())) {
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_BACK_STATUS, 1);
                                }});
                            }});
                        } else if (type.equals(TaskStatusQueryEqEnum.BACKED.getValue())) {
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_BACK_STATUS, 2);
                                }});
                            }});
                        } else if (type.equals(TaskStatusQueryEqEnum.HANG.getValue())) {
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_TASK_STATUS, 2);
                                }});
                            }});
                        } else if (type.equals(TaskStatusQueryEqEnum.TIMEOUT.getValue())) {
                            andJson.add(new JSONObject() {{
                                put(NormalConstant.STR_TERM, new JSONObject() {{
                                    put(EsSearchFieldConstant.ES_FIELD_TASK_TIMEOUT_STATUS, 1);
                                }});
                            }});
                        }
                    }
                }
            }
        }


    }




}
