package cn.gtmap.gtc.workflow.domain.manage;

import java.io.Serializable;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/2/18
 * @description  用户活动节点信息
 */

public class ForwardTaskDto implements Serializable {

    private static final long serialVersionUID = 6790262826848187066L;
    //流程定义Id
    private String procDefId;
    
    //节点名称
    private String activityName;
    
    //角色组任务, 角色id列表
    private List<String> roleIds;

    //人员组任务, 用户名列表
    private List<String> usernames;


   /*
   *
   *   提交数据参数
   * */

    // 任务ID
    private String taskId;

    //节点id
    private String activityId;

    // 选择转发的角色Id列表，','间隔
    private String selectRoleIds;

    // 选择转发的人员列表，','间隔， 全部用户allUser
    private String selectUserNames;

    // 意见
    private String opinion;


    //默认用户名
    private String defaultUserName;

    //是否默认选择节点
    private boolean isDefaultNode = false;

    //是否分管节点
    private boolean isInChargeNode= false;

    //是否部门过滤转发节点
    private boolean isDeptFilterForwardNode= false;

    //默认角色
    private String defaultRoleId;

    private boolean isBackTask;

    private boolean dispatchEnable;

    //默认用户请假状态
    private int defaultUserEnabled;

    private int nodeSort;

    /**
     * 是否是自动转发
     */
    private boolean nodeAutoComplete = false;

    public boolean isNodeAutoComplete() {
        return nodeAutoComplete;
    }

    public void setNodeAutoComplete(boolean nodeAutoComplete) {
        this.nodeAutoComplete = nodeAutoComplete;
    }

    public int getDefaultUserEnabled() {
        return defaultUserEnabled;
    }

    public void setDefaultUserEnabled(int defaultUserEnabled) {
        this.defaultUserEnabled = defaultUserEnabled;
    }

    public boolean isBackTask() {
        return isBackTask;
    }

    public void setBackTask(boolean backTask) {
        isBackTask = backTask;
    }

    public boolean isDispatchEnable() {
        return dispatchEnable;
    }

    public void setDispatchEnable(boolean dispatchEnable) {
        this.dispatchEnable = dispatchEnable;
    }

    public String getDefaultRoleId() {
        return defaultRoleId;
    }

    public void setDefaultRoleId(String defaultRuleId) {
        this.defaultRoleId = defaultRuleId;
    }

    public String getTaskId() {
        return taskId;
    }


    public String getDefaultUserName() {
        return defaultUserName;
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    public ForwardTaskDto setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public ForwardTaskDto setProcDefId(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public int getNodeSort() {
        return nodeSort;
    }

    public void setNodeSort(int nodeSort) {
        this.nodeSort = nodeSort;
    }

    public String getActivityId() {
        return activityId;
    }

    public ForwardTaskDto setActivityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    public String getActivityName() {
        return activityName;
    }

    public ForwardTaskDto setActivityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public List<String> getRoleIds() {
        return roleIds;
    }

    public ForwardTaskDto setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public List<String> getUsernames() {
        return usernames;
    }

    public ForwardTaskDto setUsernames(List<String> usernames) {
        this.usernames = usernames;
        return this;
    }

    public String getSelectRoleIds() {
        return selectRoleIds;
    }

    public ForwardTaskDto setSelectRoleIds(String selectRoleIds) {
        this.selectRoleIds = selectRoleIds;
        return this;
    }

    public String getSelectUserNames() {
        return selectUserNames;
    }

    public ForwardTaskDto setSelectUserNames(String selectUserNames) {
        this.selectUserNames = selectUserNames;
        return this;
    }

    public String getOpinion() {
        return opinion;
    }

    public ForwardTaskDto setOpinion(String opinion) {
        this.opinion = opinion;
        return this;
    }

    public boolean isDefaultNode() {
        return isDefaultNode;
    }

    public ForwardTaskDto setDefaultNode(boolean defaultNode) {
        isDefaultNode = defaultNode;
        return this;
    }

    public boolean isInChargeNode() {
        return isInChargeNode;
    }

    public void setInChargeNode(boolean inChargeNode) {
        isInChargeNode = inChargeNode;
    }

    public boolean isDeptFilterForwardNode() {
        return isDeptFilterForwardNode;
    }

    public void setDeptFilterForwardNode(boolean deptFilterForwardNode) {
        isDeptFilterForwardNode = deptFilterForwardNode;
    }
}
