package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.StatisticsProcDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/28
 * @description
 */

@FeignClient(name = "${app.services.bpm-manage:bpm-manage}")
@RequestMapping("/manage/v1")
public interface StatisticsProcessClient {

    /*
    * 根据流程实例Id,获取流程统计信息
    *
    * @deprecated  in favor of using {@link StatisticsProcessClient#queryProcessStaticsInfo}
    * */
    @GetMapping("/process-statistics/{processInsId}")
    @Deprecated
    StatisticsProcDto getProcessInsExtendList(@PathVariable("processInsId") String processInsId);

    /*
     * 根据流程实例Id,获取流程统计信息
     * */
    @GetMapping("/process-statistics/info/{processInsId}")
    StatisticsProcDto queryProcessStaticsInfo(@PathVariable("processInsId") String processInsId);
}
